/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.collections.Collection;
import org.exist.dom.QName;
import org.exist.dom.persistent.DefaultDocumentSet;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.NewArrayNodeSet;
import org.exist.dom.persistent.NodeHandle;
import org.exist.dom.persistent.NodeProxy;
import org.exist.numbering.NodeId;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.UpdateListener;
import org.exist.storage.lock.Lock;
import org.exist.util.LockException;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;

public class ExtCollection
extends Function {
    protected static final Logger logger = LogManager.getLogger(ExtCollection.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("collection", "http://www.w3.org/2005/xpath-functions"), "Returns the documents contained in the collections specified in the input sequence. Collection URIs can be specified either as a simple collection path or an XMLDB URI. Documents contained in subcollections are also included. If no value is supplied, the statically know documents are used, for the REST Server this could be the addressed collection.", new SequenceType[]{new FunctionParameterSequenceType("collection-uris", 22, 7, "The collection-URIs for which to include the documents")}, (SequenceType)new FunctionReturnSequenceType(-1, 7, "The document nodes contained in or under the given collections"), true);
    private boolean includeSubCollections = false;
    private UpdateListener listener = null;

    public ExtCollection(XQueryContext context) {
        this(context, signature, true);
    }

    public ExtCollection(XQueryContext context, FunctionSignature signature, boolean inclusive) {
        super(context, signature);
        this.includeSubCollections = inclusive;
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        List<String> args = this.getParameterValues(contextSequence, contextItem);
        DocumentSet docs = null;
        try {
            if (args.size() == 0) {
                docs = this.context.getStaticallyKnownDocuments();
            } else {
                DefaultDocumentSet ndocs = new DefaultDocumentSet();
                for (String next : args) {
                    XmldbURI uri = new AnyURIValue(next).toXmldbURI();
                    Collection coll = this.context.getBroker().getCollection(uri);
                    if (coll == null) {
                        if (!this.context.isRaiseErrorOnFailedRetrieval()) continue;
                        throw new XPathException("FODC0002: can not access collection '" + uri + "'");
                    }
                    if (this.context.inProtectedMode()) {
                        this.context.getProtectedDocs().getDocsByCollection(coll, ndocs);
                        continue;
                    }
                    coll.allDocs(this.context.getBroker(), ndocs, this.includeSubCollections, this.context.getProtectedDocs());
                }
                docs = ndocs;
            }
        }
        catch (XPathException e) {
            e.setLocation(this.line, this.column);
            throw new XPathException("FODC0002: " + e.getMessage());
        }
        catch (PermissionDeniedException pde) {
            throw new XPathException("FODC0002: can not access collection '" + pde.getMessage() + "'");
        }
        NewArrayNodeSet result = new NewArrayNodeSet();
        Iterator<DocumentImpl> i = docs.getDocumentIterator();
        while (i.hasNext()) {
            DocumentImpl doc = i.next();
            Lock dlock = doc.getUpdateLock();
            boolean lockAcquired = false;
            try {
                if (!this.context.inProtectedMode() && !dlock.hasLock()) {
                    dlock.acquire(Lock.LockMode.READ_LOCK);
                    lockAcquired = true;
                }
                result.add(new NodeProxy(doc));
            }
            catch (LockException e) {
                throw new XPathException(e.getMessage());
            }
            finally {
                if (!lockAcquired) continue;
                dlock.release(Lock.LockMode.READ_LOCK);
            }
        }
        this.registerUpdateListener();
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    private List<String> getParameterValues(Sequence contextSequence, Item contextItem) throws XPathException {
        ArrayList<String> args = new ArrayList<String>(this.getArgumentCount() + 10);
        for (int i = 0; i < this.getArgumentCount(); ++i) {
            Sequence seq = this.getArgument(i).eval(contextSequence, contextItem);
            SequenceIterator j = seq.iterate();
            while (j.hasNext()) {
                Item next = j.nextItem();
                args.add(next.getStringValue());
            }
        }
        return args;
    }

    protected void registerUpdateListener() {
        if (this.listener == null) {
            this.listener = new UpdateListener(){

                @Override
                public void documentUpdated(DocumentImpl document, int event) {
                }

                @Override
                public void unsubscribe() {
                    ExtCollection.this.listener = null;
                }

                @Override
                public void nodeMoved(NodeId oldNodeId, NodeHandle newNode) {
                }

                @Override
                public void debug() {
                    LOG.debug("UpdateListener: Line: " + ExtCollection.this.getLine() + ": " + ExtCollection.this.toString());
                }
            };
            this.context.registerUpdateListener(this.listener);
        }
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
    }
}

