/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import java.math.BigDecimal;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.DecimalValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class FnFormatNumbers
extends BasicFunction {
    private static final char DECIMAL_SEPARATOR_SIGN = '.';
    private static final char GROUPING_SEPARATOR_SIGN = ',';
    private static final String INFINITY = "Infinity";
    private static final char MINUS_SIGN = '-';
    private static final String NaN = "NaN";
    private static final char PERCENT_SIGN = '%';
    private static final char PER_MILLE_SIGN = '\u2030';
    private static final char MANDATORY_DIGIT_SIGN = '0';
    private static final char OPTIONAL_DIGIT_SIGN = '#';
    private static final char PATTERN_SEPARATOR_SIGN = ';';
    private static final SequenceType NUMBER_PARAMETER = new FunctionParameterSequenceType("value", 30, 3, "The number to format");
    private static final SequenceType PICTURE = new FunctionParameterSequenceType("picture", 22, 2, "The format pattern string.  Please see the JavaDoc for java.text.DecimalFormat to get the specifics of this format string.");
    private static final String PICTURE_DESCRIPTION = "The formatting of a number is controlled by a picture string. The picture string is a sequence of \u00b7characters\u00b7, in which the characters assigned to the variables decimal-separator-sign, grouping-sign, decimal-digit-family, optional-digit-sign and pattern-separator-sign are classified as active characters, and all other characters (including the percent-sign and per-mille-sign) are classified as passive characters.";
    private static final SequenceType DECIMAL_FORMAT = new FunctionParameterSequenceType("decimal-format-name", 22, 2, "The decimal-format name must be a QName, which is expanded as described in [2.4 Qualified Names]. It is an error if the stylesheet does not contain a declaration of the decimal-format with the specified expanded-name.");
    private static final String DECIMAL_FORMAT_DESCRIPTION = "";
    private static final FunctionReturnSequenceType FUNCTION_RETURN_TYPE = new FunctionReturnSequenceType(22, 2, "the formatted string");
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("format-number", "http://www.w3.org/2005/xpath-functions", ""), "The formatting of a number is controlled by a picture string. The picture string is a sequence of \u00b7characters\u00b7, in which the characters assigned to the variables decimal-separator-sign, grouping-sign, decimal-digit-family, optional-digit-sign and pattern-separator-sign are classified as active characters, and all other characters (including the percent-sign and per-mille-sign) are classified as passive characters.", new SequenceType[]{NUMBER_PARAMETER, PICTURE}, FUNCTION_RETURN_TYPE), new FunctionSignature(new QName("format-number", "http://www.w3.org/2005/xpath-functions", ""), "", new SequenceType[]{NUMBER_PARAMETER, PICTURE, DECIMAL_FORMAT}, FUNCTION_RETURN_TYPE)};

    public FnFormatNumbers(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        NumericValue numericValue = (NumericValue)args[0].itemAt(0);
        try {
            Formatter[] formatters = this.prepare(args[1].getStringValue());
            String value = this.format(formatters[0], numericValue);
            return new StringValue(value);
        }
        catch (IllegalArgumentException e) {
            throw new XPathException((Expression)this, e.getMessage(), (Throwable)e);
        }
    }

    private String format(Formatter f, NumericValue numericValue) throws XPathException {
        String minuSign;
        if (numericValue.isNaN()) {
            return NaN;
        }
        f.format();
        String string = minuSign = numericValue.isNegative() ? String.valueOf('-') : DECIMAL_FORMAT_DESCRIPTION;
        if (numericValue.isInfinite()) {
            return minuSign + f.prefix + INFINITY + f.suffix;
        }
        IntegerValue factor = f.isPercent ? new IntegerValue(100L) : (f.isPerMille ? new IntegerValue(1000L) : null);
        if (factor != null) {
            numericValue = (NumericValue)numericValue.mult(factor);
        }
        int pl = 0;
        StringBuilder sb = new StringBuilder();
        if (numericValue.hasFractionalPart()) {
            BigDecimal val = ((DecimalValue)numericValue.convertTo(32)).getValue();
            val = val.setScale(f.flMAX, 6);
            String number = val.toPlainString();
            sb.append(number);
            pl = number.indexOf(46);
            if (pl < 0) {
                sb.append('.');
                for (int i = 0; i < f.flMIN; ++i) {
                    sb.append('0');
                }
            }
        } else {
            String str = numericValue.getStringValue();
            pl = str.length();
            this.formatInt(str, sb, f);
        }
        if (f.mg != 0) {
            for (int pos = pl - f.mg; pos > 0; pos -= f.mg) {
                sb.insert(pos, ',');
            }
        }
        return sb.toString();
    }

    private void formatInt(String number, StringBuilder sb, Formatter f) {
        int i;
        int leadingZ = f.mlMIN - number.length();
        for (i = 0; i < leadingZ; ++i) {
            sb.append('0');
        }
        sb.append(number);
        if (f.flMIN > 0) {
            sb.append(".");
            for (i = 0; i < f.flMIN; ++i) {
                sb.append('0');
            }
        }
    }

    private Formatter[] prepare(String picture) throws XPathException {
        if (picture.length() == 0) {
            throw new XPathException((Expression)this, ErrorCodes.FODF1310, "format-number() picture is zero-length");
        }
        String[] pics = picture.split(String.valueOf(';'));
        Formatter[] formatters = new Formatter[pics.length];
        for (int i = 0; i < pics.length; ++i) {
            formatters[i] = new Formatter(this, pics[i]);
        }
        return formatters;
    }

    private static class Formatter {
        private final Expression xqueryExpr;
        private final String picture;
        private String prefix = "";
        private String suffix = "";
        private boolean ds = false;
        private boolean isPercent = false;
        private boolean isPerMille = false;
        private int mlMAX = 0;
        private int flMAX = 0;
        private int mlMIN = 0;
        private int flMIN = 0;
        private int mg = 0;
        private int fg = 0;

        public Formatter(Expression xqueryExpr, String picture) {
            this.xqueryExpr = xqueryExpr;
            this.picture = picture;
        }

        public void format() throws XPathException {
            if (!this.picture.contains(String.valueOf('#')) && !this.picture.contains(String.valueOf('0'))) {
                throw new XPathException(this.xqueryExpr, ErrorCodes.FODF1310, "A sub-picture must contain at least one character that is an optional-digit-sign or a member of the decimal-digit-family.");
            }
            int bmg = -1;
            int bfg = -1;
            ParsePhase phase = ParsePhase.BEGINNING_PASSIVE_CHARS;
            block36: for (int i = 0; i < this.picture.length(); ++i) {
                char ch = this.picture.charAt(i);
                switch (ch) {
                    case '#': {
                        switch (phase) {
                            case BEGINNING_PASSIVE_CHARS: 
                            case DIGIT_SIGNS: {
                                ++this.mlMAX;
                                phase = ParsePhase.BEGINNING_PASSIVE_CHARS;
                                continue block36;
                            }
                            case ZERO_SIGNS: {
                                throw new XPathException(this.xqueryExpr, ErrorCodes.FODF1310, FnFormatNumbers.DECIMAL_FORMAT_DESCRIPTION);
                            }
                            case FRACTIONAL_ZERO_SIGNS: 
                            case FRACTIONAL_DIGIT_SIGNS: {
                                ++this.flMAX;
                                phase = ParsePhase.FRACTIONAL_DIGIT_SIGNS;
                                continue block36;
                            }
                            case ENDING_PASSIVE_CHARS: {
                                throw new XPathException(this.xqueryExpr, ErrorCodes.FODF1310, "A sub-picture must not contain a passive character that is preceded by an active character and that is followed by another active character. Found at optional-digit-sign.");
                            }
                        }
                        continue block36;
                    }
                    case '0': {
                        switch (phase) {
                            case BEGINNING_PASSIVE_CHARS: 
                            case DIGIT_SIGNS: 
                            case ZERO_SIGNS: {
                                ++this.mlMIN;
                                ++this.mlMAX;
                                phase = ParsePhase.ZERO_SIGNS;
                                continue block36;
                            }
                            case FRACTIONAL_ZERO_SIGNS: {
                                ++this.flMIN;
                                ++this.flMAX;
                                continue block36;
                            }
                            case FRACTIONAL_DIGIT_SIGNS: {
                                throw new XPathException(this.xqueryExpr, ErrorCodes.FODF1310, FnFormatNumbers.DECIMAL_FORMAT_DESCRIPTION);
                            }
                            case ENDING_PASSIVE_CHARS: {
                                throw new XPathException(this.xqueryExpr, ErrorCodes.FODF1310, "A sub-picture must not contain a passive character that is preceded by an active character and that is followed by another active character. Found at mandatory-digit-sign.");
                            }
                        }
                        continue block36;
                    }
                    case ',': {
                        switch (phase) {
                            case BEGINNING_PASSIVE_CHARS: 
                            case DIGIT_SIGNS: 
                            case ZERO_SIGNS: {
                                if (bmg == -1) {
                                    bmg = i;
                                    continue block36;
                                }
                                this.mg = i - bmg;
                                bmg = -1;
                                continue block36;
                            }
                            case FRACTIONAL_ZERO_SIGNS: 
                            case FRACTIONAL_DIGIT_SIGNS: {
                                if (bfg == -1) {
                                    bfg = i;
                                    continue block36;
                                }
                                this.fg = i - bfg;
                                bfg = -1;
                                continue block36;
                            }
                            case ENDING_PASSIVE_CHARS: {
                                throw new XPathException(this.xqueryExpr, ErrorCodes.FODF1310, "A sub-picture must not contain a passive character that is preceded by an active character and that is followed by another active character. Found at grouping-separator-sign.");
                            }
                        }
                        continue block36;
                    }
                    case '.': {
                        switch (phase) {
                            case BEGINNING_PASSIVE_CHARS: 
                            case DIGIT_SIGNS: 
                            case ZERO_SIGNS: {
                                if (bmg != -1) {
                                    this.mg = i - bmg - 1;
                                    bmg = -1;
                                }
                                this.ds = true;
                                phase = ParsePhase.FRACTIONAL_ZERO_SIGNS;
                                continue block36;
                            }
                            case FRACTIONAL_ZERO_SIGNS: 
                            case FRACTIONAL_DIGIT_SIGNS: 
                            case ENDING_PASSIVE_CHARS: {
                                if (this.ds) {
                                    throw new XPathException(this.xqueryExpr, ErrorCodes.FODF1310, "A sub-picture must not contain more than one decimal-separator-sign.");
                                }
                                throw new XPathException(this.xqueryExpr, ErrorCodes.FODF1310, "A sub-picture must not contain a passive character that is preceded by an active character and that is followed by another active character. Found at decimal-separator-sign.");
                            }
                        }
                        continue block36;
                    }
                    case '%': 
                    case '\u2030': {
                        if (this.isPercent || this.isPerMille) {
                            throw new XPathException(this.xqueryExpr, ErrorCodes.FODF1310, "A sub-picture must not contain more than one percent-sign or per-mille-sign, and it must not contain one of each.");
                        }
                        this.isPercent = ch == '%';
                        this.isPerMille = ch == '\u2030';
                        switch (phase) {
                            case BEGINNING_PASSIVE_CHARS: {
                                this.prefix = this.prefix + ch;
                                break;
                            }
                            case DIGIT_SIGNS: 
                            case ZERO_SIGNS: 
                            case FRACTIONAL_ZERO_SIGNS: 
                            case FRACTIONAL_DIGIT_SIGNS: 
                            case ENDING_PASSIVE_CHARS: {
                                phase = ParsePhase.ENDING_PASSIVE_CHARS;
                                this.suffix = this.suffix + ch;
                            }
                        }
                        continue block36;
                    }
                    default: {
                        switch (phase) {
                            case BEGINNING_PASSIVE_CHARS: {
                                this.prefix = this.prefix + ch;
                                continue block36;
                            }
                            case DIGIT_SIGNS: 
                            case ZERO_SIGNS: 
                            case FRACTIONAL_ZERO_SIGNS: 
                            case FRACTIONAL_DIGIT_SIGNS: 
                            case ENDING_PASSIVE_CHARS: {
                                if (bmg != -1) {
                                    this.mg = i - bmg - 1;
                                    bmg = -1;
                                }
                                this.suffix = this.suffix + ch;
                                phase = ParsePhase.ENDING_PASSIVE_CHARS;
                            }
                        }
                    }
                }
            }
            if (this.mlMIN == 0 && !this.ds) {
                this.mlMIN = 1;
            }
        }

        static enum ParsePhase {
            BEGINNING_PASSIVE_CHARS,
            DIGIT_SIGNS,
            ZERO_SIGNS,
            FRACTIONAL_ZERO_SIGNS,
            FRACTIONAL_DIGIT_SIGNS,
            ENDING_PASSIVE_CHARS;

        }
    }
}

