/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.exist.dom.QName;
import org.exist.numbering.NodeId;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.ValueSequence;

public class FnOuterMost
extends BasicFunction {
    public static final FunctionSignature FNS_OUTERMOST = new FunctionSignature(new QName("outermost", "http://www.w3.org/2005/xpath-functions"), "Returns every node within the input sequence that has no ancestor that is itself a member of the input sequence; the nodes are returned in document order with duplicates eliminated.", new SequenceType[]{new FunctionParameterSequenceType("nodes", -1, 7, "The nodes to test")}, new FunctionReturnSequenceType(-1, 7, "The nodes that have no ancestor which is itself in the input sequence"));

    public FnOuterMost(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence nodes = args[0];
        if (nodes.isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        if (nodes.hasOne()) {
            return nodes;
        }
        ValueSequence results = new ValueSequence();
        List<NodeId> nodeIds = this.getNodeIds(nodes);
        HashSet<NodeId> found = new HashSet<NodeId>();
        SequenceIterator it = nodes.iterate();
        while (it.hasNext()) {
            Item item = it.nextItem();
            NodeValue node = (NodeValue)item;
            NodeId currentNodeId = node.getNodeId();
            if (found.contains(currentNodeId) || !nodeIds.parallelStream().noneMatch(nodeId -> currentNodeId.isDescendantOf((NodeId)nodeId))) continue;
            results.add(node);
            found.add(currentNodeId);
        }
        return results;
    }

    private List<NodeId> getNodeIds(Sequence nodes) throws XPathException {
        ArrayList<NodeId> nodeIds = new ArrayList<NodeId>();
        SequenceIterator it = nodes.iterate();
        while (it.hasNext()) {
            Item item = it.nextItem();
            NodeValue node = (NodeValue)item;
            nodeIds.add(node.getNodeId());
        }
        return nodeIds;
    }
}

