/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AbstractDateTimeValue;
import org.exist.xquery.value.DayTimeDurationValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FunAdjustTimezone
extends BasicFunction {
    public static final FunctionParameterSequenceType DATE_TIME_01_PARAM = new FunctionParameterSequenceType("date-time", 50, 3, "The date-time");
    public static final FunctionParameterSequenceType DATE_01_PARAM = new FunctionParameterSequenceType("date", 51, 3, "The date");
    public static final FunctionParameterSequenceType TIME_01_PARAM = new FunctionParameterSequenceType("time", 52, 3, "The time");
    public static final FunctionParameterSequenceType DURATION_01_PARAM = new FunctionParameterSequenceType("duration", 55, 3, "The duration");
    public static final FunctionReturnSequenceType DATE_TIME_01_RETURN = new FunctionReturnSequenceType(50, 3, "the adjusted date-time");
    public static final FunctionReturnSequenceType DATE_01_RETURN = new FunctionReturnSequenceType(51, 3, "the adjusted date");
    public static final FunctionReturnSequenceType TIME_01_RETURN = new FunctionReturnSequenceType(52, 3, "the adjusted time");
    public static final FunctionSignature[] fnAdjustDateTimeToTimezone = new FunctionSignature[]{new FunctionSignature(new QName("adjust-dateTime-to-timezone", "http://www.w3.org/2005/xpath-functions"), "Adjusts the xs:dateTime value $date-time to the implicit timezone of the current locale.", new SequenceType[]{DATE_TIME_01_PARAM}, DATE_TIME_01_RETURN), new FunctionSignature(new QName("adjust-dateTime-to-timezone", "http://www.w3.org/2005/xpath-functions"), "Adjusts the xs:dateTime value $date-time to a specific timezone, or to no timezone at all. If $duration is the empty sequence, returns an xs:dateTime without a timezone.", new SequenceType[]{DATE_TIME_01_PARAM, DURATION_01_PARAM}, DATE_TIME_01_RETURN)};
    public static final FunctionSignature[] fnAdjustDateToTimezone = new FunctionSignature[]{new FunctionSignature(new QName("adjust-date-to-timezone", "http://www.w3.org/2005/xpath-functions"), "Adjusts the xs:date value $date to the implicit timezone of the current locale.", new SequenceType[]{DATE_01_PARAM}, DATE_01_RETURN), new FunctionSignature(new QName("adjust-date-to-timezone", "http://www.w3.org/2005/xpath-functions"), "Adjusts the xs:date value $date to a specific timezone, or to no timezone at all. If $duration is the empty sequence, returns an xs:date without a timezone.", new SequenceType[]{DATE_01_PARAM, DURATION_01_PARAM}, DATE_01_RETURN)};
    public static final FunctionSignature[] fnAdjustTimeToTimezone = new FunctionSignature[]{new FunctionSignature(new QName("adjust-time-to-timezone", "http://www.w3.org/2005/xpath-functions"), "Adjusts the xs:time value $time to the implicit timezone of the current locale.", new SequenceType[]{TIME_01_PARAM}, TIME_01_RETURN), new FunctionSignature(new QName("adjust-time-to-timezone", "http://www.w3.org/2005/xpath-functions"), "Adjusts the xs:time value $time to a specific timezone, or to no timezone at all. If $duration is the empty sequence, returns an xs:time without a timezone.", new SequenceType[]{TIME_01_PARAM, DURATION_01_PARAM}, TIME_01_RETURN)};

    public FunAdjustTimezone(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        if (args[0].isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            AbstractDateTimeValue time = (AbstractDateTimeValue)args[0].itemAt(0);
            if (this.getSignature().getArgumentCount() == 2) {
                if (args[1].isEmpty()) {
                    result = time.withoutTimezone();
                } else {
                    DayTimeDurationValue offset = (DayTimeDurationValue)args[1].itemAt(0);
                    result = time.adjustedToTimezone(offset);
                }
            } else {
                result = time.adjustedToTimezone(null);
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

