/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exist.dom.QName;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.util.PatternFactory;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.regex.RegexUtil;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xml.sax.helpers.AttributesImpl;

public class FunAnalyzeString
extends BasicFunction {
    private static final QName fnAnalyzeString = new QName("analyze-string", "http://www.w3.org/2005/xpath-functions");
    private static final QName QN_MATCH = new QName("match", "http://www.w3.org/2005/xpath-functions");
    private static final QName QN_GROUP = new QName("group", "http://www.w3.org/2005/xpath-functions");
    private static final QName QN_NR = new QName("nr", "");
    private static final QName QN_NON_MATCH = new QName("non-match", "http://www.w3.org/2005/xpath-functions");
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(fnAnalyzeString, "Analyzes a string using a regular expression, returning an XML structure that identifies which parts of the input string matched or failed to match the regular expression, and in the case of matched substrings, which substrings matched each capturing group in the regular expression.", new SequenceType[]{new FunctionParameterSequenceType("input", 22, 3, "The input string"), new FunctionParameterSequenceType("pattern", 22, 2, "The pattern")}, new FunctionReturnSequenceType(1, 2, "The result of the analysis")), new FunctionSignature(fnAnalyzeString, "Analyzes a string using a regular expression, returning an XML structure that identifies which parts of the input string matched or failed to match the regular expression, and in the case of matched substrings, which substrings matched each capturing group in the regular expression.", new SequenceType[]{new FunctionParameterSequenceType("input", 22, 3, "The input string"), new FunctionParameterSequenceType("pattern", 22, 2, "The pattern"), new FunctionParameterSequenceType("flags", 22, 2, "Flags")}, new FunctionReturnSequenceType(1, 2, "The result of the analysis"))};

    public FunAnalyzeString(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        MemTreeBuilder builder = new MemTreeBuilder(this.context);
        builder.startDocument();
        builder.startElement(new QName("analyze-string-result", "http://www.w3.org/2005/xpath-functions"), null);
        String input = "";
        if (!args[0].isEmpty()) {
            input = args[0].itemAt(0).getStringValue();
        }
        if (!"".equals(input)) {
            String pattern = args[1].itemAt(0).getStringValue();
            String flags = null;
            if (args.length == 3) {
                flags = args[2].itemAt(0).getStringValue();
            }
            this.analyzeString(builder, input, pattern, flags);
        }
        builder.endElement();
        builder.endDocument();
        return (NodeValue)((Object)builder.getDocument().getDocumentElement());
    }

    private void analyzeString(MemTreeBuilder builder, String input, String pattern, String flags) throws XPathException {
        int iFlags = RegexUtil.parseFlags(this, flags);
        if (!RegexUtil.hasLiteral(iFlags)) {
            pattern = RegexUtil.translateRegexp(this, pattern, RegexUtil.hasIgnoreWhitespace(iFlags), RegexUtil.hasCaseInsensitive(iFlags));
        }
        Pattern ptn = PatternFactory.getInstance().getPattern(pattern, iFlags);
        Matcher matcher = ptn.matcher(input);
        int offset = 0;
        while (matcher.find()) {
            if (matcher.start() != offset) {
                this.nonMatch(builder, input.substring(offset, matcher.start()));
            }
            this.match(builder, matcher, input, 0);
            offset = matcher.end();
        }
        if (offset != input.length()) {
            this.nonMatch(builder, input.substring(offset));
        }
    }

    private GroupPosition match(MemTreeBuilder builder, Matcher matcher, String input, int group) {
        if (group == 0) {
            builder.startElement(QN_MATCH, null);
        } else {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", QN_NR.getLocalPart(), QN_NR.getLocalPart(), "int", Integer.toString(group));
            builder.startElement(QN_GROUP, attributes);
        }
        int groupStart = matcher.start(group);
        int groupEnd = matcher.end(group);
        int groupCount = matcher.groupCount();
        GroupPosition groupAndPosition = new GroupPosition(group + 1, groupStart);
        while (groupAndPosition.groupNumber <= groupCount && matcher.end(groupAndPosition.groupNumber) <= groupEnd) {
            int start = matcher.start(groupAndPosition.groupNumber);
            if (start >= 0) {
                if (groupAndPosition.position < start) {
                    builder.characters(input.substring(groupAndPosition.position, start));
                }
                groupAndPosition = this.match(builder, matcher, input, groupAndPosition.groupNumber);
                continue;
            }
            ++groupAndPosition.groupNumber;
        }
        if (groupAndPosition.position < groupEnd) {
            builder.characters(input.substring(groupAndPosition.position, groupEnd));
            groupAndPosition.position = groupEnd;
        }
        builder.endElement();
        return groupAndPosition;
    }

    private void nonMatch(MemTreeBuilder builder, String nonMatch) {
        builder.startElement(QN_NON_MATCH, null);
        builder.characters(nonMatch);
        builder.endElement();
    }

    private static class GroupPosition {
        public int groupNumber;
        public int position;

        public GroupPosition(int groupNumber, int position) {
            this.groupNumber = groupNumber;
            this.position = position;
        }
    }
}

