/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;
import org.w3c.dom.Node;

public class FunBaseURI
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(FunBaseURI.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("base-uri", "http://www.w3.org/2005/xpath-functions"), "Returns the value of the base URI property for the context item.", null, new FunctionReturnSequenceType(25, 3, "The base URI from the context item")), new FunctionSignature(new QName("base-uri", "http://www.w3.org/2005/xpath-functions"), "Returns the value of the base URI property for $uri. If $uri is the empty sequence, the empty sequence is returned.", new SequenceType[]{new FunctionParameterSequenceType("uri", -1, 3, "The URI")}, new FunctionReturnSequenceType(25, 3, "the base URI from $uri")), new FunctionSignature(new QName("static-base-uri", "http://www.w3.org/2005/xpath-functions"), "Returns the value of the base URI property from the static context. If the base-uri property is undefined, the empty sequence is returned.", null, new FunctionReturnSequenceType(25, 3, "The base URI from the static context"))};

    public FunBaseURI(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        Sequence result = null;
        NodeValue node = null;
        if (this.isCalledAs("static-base-uri")) {
            if (this.context.isBaseURIDeclared()) {
                result = this.context.getBaseURI();
                if (!((AnyURIValue)result).toURI().isAbsolute()) {
                    LOG.debug("URI is not absolute");
                    result = Sequence.EMPTY_SEQUENCE;
                }
            } else {
                result = Sequence.EMPTY_SEQUENCE;
            }
        } else if (args.length == 0) {
            if (contextSequence == null || contextSequence.isEmpty()) {
                throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Context sequence is empty and no argument specified");
            }
            Item item = contextSequence.itemAt(0);
            if (!Type.subTypeOf(item.getType(), -1)) {
                throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "Context item is not a node");
            }
            node = (NodeValue)item;
        } else if (args[0].isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            node = (NodeValue)args[0].itemAt(0);
        }
        if (result == null && node != null) {
            result = Sequence.EMPTY_SEQUENCE;
            Node domNode = node.getNode();
            short type = domNode.getNodeType();
            if (!(type != 9 && domNode.getParentNode() == null || (type == 7 || type == 8) && domNode.getParentNode() != null && domNode.getParentNode().getNodeType() == 9 || type != 2 && type != 1 && type != 9 && type != 7 && type != 8)) {
                URI relativeURI = null;
                URI baseURI = null;
                try {
                    String uri = domNode.getBaseURI();
                    if (uri != null) {
                        relativeURI = new URI(uri);
                        baseURI = new URI(this.context.getBaseURI() + "/");
                    }
                }
                catch (URISyntaxException e) {
                    throw new XPathException(e.getMessage());
                }
                if (relativeURI != null) {
                    result = !("".equals(relativeURI.toString()) || type == 2 && "/db".equals(relativeURI.toString())) ? (relativeURI.isAbsolute() ? new AnyURIValue(relativeURI) : new AnyURIValue(baseURI.resolve(relativeURI))) : new AnyURIValue(baseURI);
                }
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

