/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import com.ibm.icu.text.Collator;
import org.exist.dom.QName;
import org.exist.util.Collations;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.fn.CollatingFunction;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FunCompare
extends CollatingFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("compare", "http://www.w3.org/2005/xpath-functions"), "Returns the collatable comparison between $string-1 and $string-2, using $collation-uri. -1 if $string-1 is inferior to $string-2, 0 if $string-1 is equal to $string-2, 1 if $string-1 is superior to $string-2. If either comparand is the empty sequence, the empty sequence is returned. Please remember to specify the collation in the context or use, the three argument version if you don't want the system default.", new SequenceType[]{new FunctionParameterSequenceType("string-1", 22, 3, "The first string"), new FunctionParameterSequenceType("string-2", 22, 3, "The second string")}, new FunctionReturnSequenceType(31, 3, "-1 if $string-1 is inferior to $string-2, 0 if $string-1 is equal to $string-2, 1 if $string-1 is superior to $string-2. If either comparand is the empty sequence, the empty sequence is returned.")), new FunctionSignature(new QName("compare", "http://www.w3.org/2005/xpath-functions"), "Returns the collatable comparison between $string-1 and $string-2, using $collation-uri. -1 if $string-1 is inferior to $string-2, 0 if $string-1 is equal to $string-2, 1 if $string-1 is superior to $string-2. If either comparand is the empty sequence, the empty sequence is returned. The third argument $collation-uri is either: 1) the full URI e.g. \"http://www.w3.org/2013/collation/UCA?lang=en;strength=secondary\", or 2) relative where you only need to specify the last part of a valid full collation-uri, e.g. \"?lang=sv-SE\", \"lang=sv-SE;strength=primary;decomposition=standard\" or \"swedish\".", new SequenceType[]{new FunctionParameterSequenceType("string-1", 22, 3, "The first string"), new FunctionParameterSequenceType("string-2", 22, 3, "The second string"), new FunctionParameterSequenceType("collation-uri", 22, 2, "The relative collation URI")}, new FunctionReturnSequenceType(31, 3, "-1 if $string-1 is inferior to $string-2, 0 if $string-1 is equal to $string-2, 1 if $string-1 is superior to $string-2. If either comparand is the empty sequence, the empty sequence is returned."))};

    public FunCompare(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Collator collator;
        int comparison;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        Sequence seq1 = this.getArgument(0).eval(contextSequence, contextItem);
        Sequence seq2 = this.getArgument(1).eval(contextSequence, contextItem);
        Sequence result = seq1.isEmpty() || seq2.isEmpty() ? Sequence.EMPTY_SEQUENCE : ((comparison = Collations.compare(collator = this.getCollator(contextSequence, contextItem, 3), seq1.getStringValue(), seq2.getStringValue())) == 0 ? new IntegerValue(0L) : (comparison < 0 ? new IntegerValue(-1L) : new IntegerValue(1L)));
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

