/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Atomize;
import org.exist.xquery.Dependency;
import org.exist.xquery.DynamicCardinalityCheck;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.Error;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;

public class FunConcat
extends Function {
    protected static final Logger logger = LogManager.getLogger(FunConcat.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("concat", "http://www.w3.org/2005/xpath-functions"), "Accepts two or more xdt:anyAtomicType arguments, $atomizable-values, and converts them to xs:string. Returns the xs:string that is the concatenation of the values of its arguments after conversion. If any of the arguments is the empty sequence, the argument is treated as the zero-length string.", new SequenceType[]{new FunctionParameterSequenceType("atomizable-values", 20, 3, "The atomizable values")}, (SequenceType)new FunctionReturnSequenceType(22, 3, "The concatenated values"), true);

    public FunConcat(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public int returnsType() {
        return 22;
    }

    @Override
    public void setArguments(List<Expression> arguments) throws XPathException {
        this.steps.clear();
        for (Expression argument : arguments) {
            if (!(argument instanceof Function.Placeholder) && !Type.subTypeOf((argument = new DynamicCardinalityCheck(this.context, 3, argument, new Error("D02", "1", this.mySignature))).returnsType(), 20)) {
                argument = new Atomize(this.context, argument);
            }
            this.steps.add(argument);
        }
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        this.inPredicate = (contextInfo.getFlags() & 2) > 0;
        for (int i = 0; i < this.getArgumentCount(); ++i) {
            this.getArgument(i).analyze(contextInfo);
        }
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (this.getArgumentCount() < 2) {
            throw new XPathException((Expression)this, ErrorCodes.XPST0017, "concat() requires at least two arguments");
        }
        StringBuilder concat = new StringBuilder();
        for (int i = 0; i < this.getArgumentCount(); ++i) {
            concat.append(this.getArgument(i).eval(contextSequence, contextItem).getStringValue());
        }
        StringValue result = new StringValue(concat.toString());
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

