/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import com.ibm.icu.text.Collator;
import org.exist.dom.QName;
import org.exist.util.Collations;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.fn.CollatingFunction;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FunContains
extends CollatingFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("contains", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:boolean indicating whether or not the value of $source-string contains (at the beginning, at the end, or anywhere within) at least one sequence of collation units that provides a minimal match to the collation units in the value of $substring, according to the default collation.", new SequenceType[]{new FunctionParameterSequenceType("source-string", 22, 3, "The source-string"), new FunctionParameterSequenceType("substring", 22, 3, "The substring")}, new FunctionReturnSequenceType(23, 2, "true() if $source-string contains $substring, false() otherwise")), new FunctionSignature(new QName("contains", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:boolean indicating whether or not the value of $source-string contains (at the beginning, at the end, or anywhere within) at least one sequence of collation units that provides a minimal match to the collation units in the value of $substring, according to the collation that is specified in $collation-uri.The third argument $collation-uri is either: 1) the full URI e.g. \"http://www.w3.org/2013/collation/UCA?lang=en;strength=secondary\", or 2) relative where you only need to specify the last part of a valid full collation-uri, e.g. \"?lang=sv-SE\", \"lang=sv-SE;strength=primary;decomposition=standard\" or \"swedish\".", new SequenceType[]{new FunctionParameterSequenceType("source-string", 22, 3, "The source-string"), new FunctionParameterSequenceType("substring", 22, 3, "The substring"), new FunctionParameterSequenceType("collation-uri", 22, 2, "The collation URI")}, new FunctionReturnSequenceType(23, 2, "true() if $source-string contains $substring, false() otherwise"))};

    public FunContains(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public int returnsType() {
        return 23;
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        BooleanValue result;
        String s2;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if ("".equals(s2 = this.getArgument(1).eval(contextSequence, contextItem).getStringValue())) {
            result = BooleanValue.TRUE;
        } else {
            String s1 = this.getArgument(0).eval(contextSequence, contextItem).getStringValue();
            if ("".equals(s1)) {
                result = BooleanValue.FALSE;
            } else {
                Collator collator = this.getCollator(contextSequence, contextItem, 3);
                return BooleanValue.valueOf(Collations.contains(collator, s1, s2));
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

