/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import org.exist.dom.QName;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FunCount
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("count", "http://www.w3.org/2005/xpath-functions"), "Returns the number of items in the argument sequence, $items.", new SequenceType[]{new FunctionParameterSequenceType("items", 11, 7, "The items")}, new FunctionReturnSequenceType(31, 2, "The number of items in the argument sequence"));

    public FunCount(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public int returnsType() {
        return 31;
    }

    @Override
    public int getDependencies() {
        if (this.getArgumentCount() == 0) {
            return 1;
        }
        return this.getArgument(0).getDependencies();
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        IntegerValue result = this.getArgumentCount() == 0 ? IntegerValue.ZERO : new IntegerValue(this.getArgument(0).eval(contextSequence).getItemCount());
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

