/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Constants;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.DateValue;
import org.exist.xquery.value.DayTimeDurationValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.TimeValue;
import org.exist.xquery.value.ValueSequence;

public class FunDateTime
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("dateTime", "http://www.w3.org/2005/xpath-functions", ""), "Creates an xs:dateTime from an xs:date, $date, and an xs:time, $time.", new SequenceType[]{new FunctionParameterSequenceType("date", 51, 3, "The date as xs:date"), new FunctionParameterSequenceType("time", 52, 3, "The time as xs:time")}, new FunctionReturnSequenceType(50, 3, "the combined date and time as xs:dateTime"));

    public FunDateTime(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        if (args[0].isEmpty() || args[1].isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            if (args[0].hasMany()) {
                throw new XPathException(this, ErrorCodes.XPTY0004, "Expected at most one xs:date", args[0]);
            }
            if (args[1].hasMany()) {
                throw new XPathException(this, ErrorCodes.XPTY0004, "Expected at most one xs:time", args[1]);
            }
            DateValue dv = (DateValue)args[0].itemAt(0);
            TimeValue tv = (TimeValue)args[1].itemAt(0);
            if (!(dv.getTimezone().isEmpty() || tv.getTimezone().isEmpty() || ((DayTimeDurationValue)dv.getTimezone().itemAt(0)).compareTo(null, Constants.Comparison.EQ, (DayTimeDurationValue)tv.getTimezone().itemAt(0)))) {
                ValueSequence argsSeq = new ValueSequence();
                argsSeq.add(dv);
                argsSeq.add(tv);
                throw new XPathException(this, ErrorCodes.FORG0008, "Operands have different timezones", argsSeq);
            }
            String dtv = ((DateTimeValue)dv.convertTo(50)).getTrimmedCalendar().toXMLFormat();
            if (dv.getTimezone().isEmpty()) {
                dtv = dtv.substring(0, dtv.length() - 8);
                result = new DateTimeValue(dtv + tv.getStringValue());
            } else if ("PT0S".equals(((DayTimeDurationValue)dv.getTimezone().itemAt(0)).getStringValue())) {
                dtv = dtv.substring(0, dtv.length() - 9);
                result = tv.getTimezone().isEmpty() ? new DateTimeValue(dtv + tv.getStringValue() + "Z") : new DateTimeValue(dtv + tv.getStringValue());
            } else if (tv.getTimezone().isEmpty()) {
                String tz = dtv.substring(19);
                dtv = dtv.substring(0, dtv.length() - 14);
                result = new DateTimeValue(dtv + tv.getStringValue() + tz);
            } else {
                dtv = dtv.substring(0, dtv.length() - 14);
                result = new DateTimeValue(dtv + tv.getStringValue());
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

