/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import com.ibm.icu.text.Collator;
import java.util.Comparator;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.Constants;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.ValueComparison;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.fn.CollatingFunction;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;

public class FunDistinctValues
extends CollatingFunction {
    protected static final Logger logger = LogManager.getLogger(FunDistinctValues.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("distinct-values", "http://www.w3.org/2005/xpath-functions", ""), "Returns a sequence where duplicate values of $atomic-values, based on value equality, have been deleted.", new SequenceType[]{new FunctionParameterSequenceType("atomic-values", 20, 7, "The atomic values")}, new FunctionReturnSequenceType(20, 7, "the distinct values sequence")), new FunctionSignature(new QName("distinct-values", "http://www.w3.org/2005/xpath-functions", ""), "Returns a sequence where duplicate values of $atomic-values, based on value equality specified by collation $collation-uri, have been deleted.", new SequenceType[]{new FunctionParameterSequenceType("atomic-values", 20, 7, "The atomic values"), new FunctionParameterSequenceType("collation-uri", 22, 2, "The collation URI")}, new FunctionReturnSequenceType(20, 7, "the distinct values sequence"))};

    public FunDistinctValues(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public int returnsType() {
        return 20;
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        Sequence seq = this.getArgument(0).eval(contextSequence, contextItem);
        Collator collator = this.getCollator(contextSequence, contextItem, 2);
        TreeSet<AtomicValue> set = new TreeSet<AtomicValue>(new ValueComparator(collator));
        ValueSequence result = new ValueSequence();
        boolean hasAlreadyNaN = false;
        SequenceIterator i = seq.iterate();
        while (i.hasNext()) {
            Item item = i.nextItem();
            AtomicValue value = item.atomize();
            if (set.contains(value)) continue;
            if (Type.subTypeOf(value.getType(), 30)) {
                if (((NumericValue)value).isNaN()) {
                    if (hasAlreadyNaN) continue;
                    set.add(value);
                    result.add(value);
                    hasAlreadyNaN = true;
                    continue;
                }
                set.add(value);
                result.add(value);
                continue;
            }
            set.add(value);
            result.add(value);
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    public static final class ValueComparator
    implements Comparator<AtomicValue> {
        Collator collator;

        public ValueComparator(Collator collator) {
            this.collator = collator;
        }

        @Override
        public int compare(AtomicValue o1, AtomicValue o2) {
            try {
                if (ValueComparison.compareAtomic(this.collator, o1, o2, Constants.StringTruncationOperator.NONE, Constants.Comparison.EQ)) {
                    return 0;
                }
                if (ValueComparison.compareAtomic(this.collator, o1, o2, Constants.StringTruncationOperator.NONE, Constants.Comparison.LT)) {
                    return -1;
                }
                if (ValueComparison.compareAtomic(this.collator, o1, o2, Constants.StringTruncationOperator.NONE, Constants.Comparison.GT)) {
                    return 1;
                }
                return o1.compareTo(this.collator, o2);
            }
            catch (XPathException e) {
                return -1;
            }
        }
    }
}

