/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.NodeHandle;
import org.exist.numbering.NodeId;
import org.exist.storage.UpdateListener;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.DocUtils;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FunDoc
extends Function {
    protected static final Logger logger = LogManager.getLogger(FunDoc.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("doc", "http://www.w3.org/2005/xpath-functions"), "Returns the document node of $document-uri. Resource URIs can be specified either as a simple collection path, an XMLDB URI or any URI.", new SequenceType[]{new FunctionParameterSequenceType("document-uri", 22, 3, "The document URI")}, new FunctionReturnSequenceType(6, 3, "the document node of $document-uri"));
    private UpdateListener listener = null;

    public FunDoc(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        Sequence arg;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if ((arg = this.getArgument(0).eval(contextSequence, contextItem)).isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            String path = arg.itemAt(0).getStringValue();
            try {
                result = DocUtils.getDocument(this.context, path);
                if (result.isEmpty() && this.context.isRaiseErrorOnFailedRetrieval()) {
                    throw new XPathException(this, ErrorCodes.FODC0002, "Can not access '" + path + "'", arg);
                }
                DocumentSet docs = result.getDocumentSet();
                if (docs != null && DocumentSet.EMPTY_DOCUMENT_SET != docs) {
                    this.registerUpdateListener();
                }
            }
            catch (Exception e) {
                throw new XPathException(this, ErrorCodes.FODC0005, e.getMessage(), arg);
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    protected void registerUpdateListener() {
        if (this.listener == null) {
            this.listener = new UpdateListener(){

                @Override
                public void documentUpdated(DocumentImpl document, int event) {
                }

                @Override
                public void unsubscribe() {
                    FunDoc.this.listener = null;
                }

                @Override
                public void nodeMoved(NodeId oldNodeId, NodeHandle newNode) {
                }

                @Override
                public void debug() {
                    logger.debug("UpdateListener: Line: " + FunDoc.this.getLine() + ": " + FunDoc.this.toString());
                }
            };
            this.context.registerUpdateListener(this.listener);
        }
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        if (!postOptimization) {
            this.listener = null;
        }
        this.getArgument(0).resetState(postOptimization);
    }
}

