/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.DocUtils;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FunDocAvailable
extends Function {
    protected static final Logger logger = LogManager.getLogger(FunDocAvailable.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("doc-available", "http://www.w3.org/2005/xpath-functions"), "Returns whether or not the document, $document-uri, specified in the input sequence is available. Resource URIs can be specified either as a simple collection path, an XMLDB URI or any URI.", new SequenceType[]{new FunctionParameterSequenceType("document-uri", 22, 3, "The document URI")}, new FunctionReturnSequenceType(23, 2, "true() if the document is available, false() otherwise"));

    public FunDocAvailable(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public int getDependencies() {
        return 1;
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        BooleanValue result = BooleanValue.FALSE;
        Sequence arg = this.getArgument(0).eval(contextSequence, contextItem);
        if (!arg.isEmpty()) {
            String path = arg.itemAt(0).getStringValue();
            try {
                new URI(path);
            }
            catch (URISyntaxException e) {
                throw new XPathException(this, ErrorCodes.FODC0005, e.getMessage(), arg, e);
            }
            try {
                result = BooleanValue.valueOf(DocUtils.isDocumentAvailable(this.context, path));
            }
            catch (XPathException e) {
                result = BooleanValue.FALSE;
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.getArgument(0).resetState(postOptimization);
    }
}

