/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;

public class FunEnvironment
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(FunEnvironment.class);
    public static final FunctionSignature[] signature = new FunctionSignature[]{new FunctionSignature(new QName("available-environment-variables", "http://www.w3.org/2005/xpath-functions"), "Returns a list of environment variable names.", null, new FunctionReturnSequenceType(22, 7, "Returns a sequence of strings, being the names of the environment variables. User must be DBA.")), new FunctionSignature(new QName("environment-variable", "http://www.w3.org/2005/xpath-functions"), "Returns the value of a system environment variable, if it exists.", new SequenceType[]{new FunctionParameterSequenceType("name", 22, 2, "Name of environment variable.")}, new FunctionReturnSequenceType(22, 1, "Corrensponding value of the environment variable, if there is no environment variable with a matching name, the function returns the empty sequence. User must be DBA."))};

    public FunEnvironment(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (!this.context.getSubject().hasDbaRole()) {
            String txt = "Permission denied, calling user '" + this.context.getSubject().getName() + "' must be a DBA to call this function.";
            logger.error(txt);
            return Sequence.EMPTY_SEQUENCE;
        }
        if (this.isCalledAs("available-environment-variables")) {
            ValueSequence result = new ValueSequence();
            Map<String, String> env = this.context.getEnvironmentVariables();
            for (String key : env.keySet()) {
                result.add(new StringValue(key));
            }
            return result;
        }
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        String parameter = args[0].itemAt(0).getStringValue();
        String value = this.context.getEnvironmentVariables().get(parameter);
        if (value == null) {
            return Sequence.EMPTY_SEQUENCE;
        }
        return new StringValue(value);
    }
}

