/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import com.ibm.icu.text.Collator;
import org.exist.dom.QName;
import org.exist.util.Collations;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.fn.CollatingFunction;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FunEquals
extends CollatingFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("equals", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:boolean indicating whether or not the value of $source-string  equals the collation units in the value of $substring, according to the default collation. This function is similar to the '=' expression, except that it uses the default collation for comparisons.", new SequenceType[]{new FunctionParameterSequenceType("source-string", 22, 3, "The source-string"), new FunctionParameterSequenceType("substring", 22, 3, "The substring")}, new FunctionReturnSequenceType(23, 2, "true() if $source-string equals $substring, false() otherwise")), new FunctionSignature(new QName("equals", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:boolean indicating whether or not the value of $source-string equals the  collation units in the value of $substring, according to the collation that is specified in $collation-uri. This function is similar to the '=' expression, except that it uses the specified collation for comparisons.The third argument $collation-uri is either: 1) the full URI e.g. \"http://www.w3.org/2013/collation/UCA?lang=en;strength=secondary\", or 2) relative where you only need to specify the last part of a valid full collation-uri, e.g. \"?lang=sv-SE\", \"lang=sv-SE;strength=primary;decomposition=standard\" or \"swedish\".", new SequenceType[]{new FunctionParameterSequenceType("source-string", 22, 3, "The source-string"), new FunctionParameterSequenceType("substring", 22, 3, "The substring"), new FunctionParameterSequenceType("collation-uri", 22, 2, "The collation URI")}, new FunctionReturnSequenceType(23, 2, "true() if $source-string equals $substring, false() otherwise"))};

    public FunEquals(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public int returnsType() {
        return 23;
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        String s1 = this.getArgument(0).eval(contextSequence, contextItem).getStringValue();
        String s2 = this.getArgument(1).eval(contextSequence, contextItem).getStringValue();
        if (s1.length() == 0 || s2.length() == 0) {
            result = s1.length() == 0 && s2.length() == 0 ? BooleanValue.TRUE : Sequence.EMPTY_SEQUENCE;
        } else {
            Collator collator = this.getCollator(contextSequence, contextItem, 3);
            if (collator == null) {
                collator = Collations.getCollationFromURI("?strength=identical");
            }
            result = Collations.equals(collator, s1, s2) ? BooleanValue.TRUE : BooleanValue.FALSE;
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

