/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import org.exist.dom.QName;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.URIUtils;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class FunEscapeHTMLURI
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("escape-html-uri", "http://www.w3.org/2005/xpath-functions"), "Replaces all non-printable ASCII characters in the string value of $html-uri by an escape sequence represented as a hexadecimal octet in the form %XX. If $html-uri is the empty sequence, returns the zero-length string.", new SequenceType[]{new FunctionParameterSequenceType("html-uri", 22, 3, "The html URI")}, new FunctionReturnSequenceType(22, 2, "all nonprintable ASCII characters in $html-uri encoded by escape sequences"));

    public FunEscapeHTMLURI(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        StringValue result;
        Sequence seq;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if ((seq = this.getArgument(0).eval(contextSequence, contextItem)).isEmpty()) {
            result = StringValue.EMPTY_STRING;
        } else {
            String value = URIUtils.escapeHtmlURI(seq.getStringValue());
            result = new StringValue(value);
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

