/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FunExactlyOne
extends Function {
    protected static final Logger logger = LogManager.getLogger(FunExactlyOne.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("exactly-one", "http://www.w3.org/2005/xpath-functions"), "Returns the argument sequence, $items, if it contains exactly one item. Otherwise, raises an error.", new SequenceType[]{new FunctionParameterSequenceType("items", 11, 7, "The item sequence")}, new FunctionReturnSequenceType(11, 2, "the sole item in $items if it contains exactly one item. Otherwise, an error is raised."));

    public FunExactlyOne(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (!(result = this.getArgument(0).eval(contextSequence, contextItem)).hasOne()) {
            logger.error("fn:exactly-one called with a sequence containing " + result.getItemCount() + " items");
            throw new XPathException(this, ErrorCodes.FOCA0005, "fn:exactly-one called with a sequence containing " + result.getItemCount() + " items", result);
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

