/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AbstractDateTimeValue;
import org.exist.xquery.value.DecimalValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FunGetDateComponent
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(FunGetDateComponent.class);
    public static final FunctionParameterSequenceType DATE_01_PARAM = new FunctionParameterSequenceType("date", 51, 3, "The date as xs:date");
    public static final FunctionParameterSequenceType TIME_01_PARAM = new FunctionParameterSequenceType("time", 52, 3, "The time as xs:time");
    public static final FunctionParameterSequenceType DATE_TIME_01_PARAM = new FunctionParameterSequenceType("date-time", 50, 3, "The date-time as xs:dateTime");
    public static final FunctionSignature fnDayFromDate = new FunctionSignature(new QName("day-from-date", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:integer between 1 and 31, both inclusive, representing the day component in the localized value of $date.", new SequenceType[]{DATE_01_PARAM}, new FunctionReturnSequenceType(31, 3, "the day component from $date"));
    public static final FunctionSignature fnMonthFromDate = new FunctionSignature(new QName("month-from-date", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:integer between 1 and 12, both inclusive, representing the month component in the localized value of $date.", new SequenceType[]{DATE_01_PARAM}, new FunctionReturnSequenceType(31, 3, "the month component from $date"));
    public static final FunctionSignature fnYearFromDate = new FunctionSignature(new QName("year-from-date", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:integer representing the year in the localized value of $date. The value may be negative.", new SequenceType[]{DATE_01_PARAM}, new FunctionReturnSequenceType(31, 3, "the year component from $date"));
    public static final FunctionSignature fnTimezoneFromDate = new FunctionSignature(new QName("timezone-from-date", "http://www.w3.org/2005/xpath-functions"), "Returns the timezone component of $date if any. If $date has a timezone component, then the result is an xs:dayTimeDuration that indicates deviation from UTC; its value may range from +14:00 to -14:00 hours, both inclusive. Otherwise, the result is the empty sequence.If $date is the empty sequence, returns the empty sequence.", new SequenceType[]{DATE_01_PARAM}, new FunctionReturnSequenceType(55, 3, "the timezone component from $date"));
    public static final FunctionSignature fnHoursFromTime = new FunctionSignature(new QName("hours-from-time", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:integer between 0 and 23, both inclusive, representing the value of the hours component in the localized value of $time.", new SequenceType[]{TIME_01_PARAM}, new FunctionReturnSequenceType(31, 3, "the hours component from $time"));
    public static final FunctionSignature fnMinutesFromTime = new FunctionSignature(new QName("minutes-from-time", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:integer value between 0 to 59, both inclusive, representing the value of the minutes component in the localized value of $time.", new SequenceType[]{TIME_01_PARAM}, new FunctionReturnSequenceType(31, 3, "the minutes component from $time"));
    public static final FunctionSignature fnSecondsFromTime = new FunctionSignature(new QName("seconds-from-time", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:decimal value between 0 and 60.999..., both inclusive, representing the seconds and fractional seconds in the localized value of $date. Note that the value can be greater than 60 seconds to accommodate occasional leap seconds used to keep human time synchronized with the rotation of the planet.", new SequenceType[]{TIME_01_PARAM}, new FunctionReturnSequenceType(32, 3, "the seconds component from $time"));
    public static final FunctionSignature fnTimezoneFromTime = new FunctionSignature(new QName("timezone-from-time", "http://www.w3.org/2005/xpath-functions"), "Returns the timezone component of $time if any. If $time has a timezone component, then the result is an xdt:dayTimeDuration that indicates deviation from UTC; its value may range from +14:00 to -14:00 hours, both inclusive. Otherwise, the result is the empty sequence.", new SequenceType[]{TIME_01_PARAM}, new FunctionReturnSequenceType(55, 3, "the timezone component from $time"));
    public static final FunctionSignature fnDayFromDateTime = new FunctionSignature(new QName("day-from-dateTime", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:integer between 1 and 31, both inclusive, representing the day component in the localized value of $date-time.", new SequenceType[]{DATE_TIME_01_PARAM}, new FunctionReturnSequenceType(31, 3, "the day component from $date-time"));
    public static final FunctionSignature fnMonthFromDateTime = new FunctionSignature(new QName("month-from-dateTime", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:integer between 1 and 12, both inclusive, representing the month component in the localized value of $date-time.", new SequenceType[]{DATE_TIME_01_PARAM}, new FunctionReturnSequenceType(31, 3, "the month component from $date-time"));
    public static final FunctionSignature fnYearFromDateTime = new FunctionSignature(new QName("year-from-dateTime", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:integer representing the year in the localized value of $date-time. The value may be negative.", new SequenceType[]{DATE_TIME_01_PARAM}, new FunctionReturnSequenceType(31, 3, "the year component from $date-time"));
    public static final FunctionSignature fnHoursFromDateTime = new FunctionSignature(new QName("hours-from-dateTime", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:integer between 0 and 23, both inclusive, representing the value of the hours component in the localized value of $date-time.", new SequenceType[]{DATE_TIME_01_PARAM}, new FunctionReturnSequenceType(31, 3, "the hours component from $date-time"));
    public static final FunctionSignature fnMinutesFromDateTime = new FunctionSignature(new QName("minutes-from-dateTime", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:integer value between 0 to 59, both inclusive, representing the value of the minutes component in the localized value of $date-time.", new SequenceType[]{DATE_TIME_01_PARAM}, new FunctionReturnSequenceType(31, 3, "the minutes component from $date-time"));
    public static final FunctionSignature fnSecondsFromDateTime = new FunctionSignature(new QName("seconds-from-dateTime", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:decimal value between 0 and 60.999..., both inclusive, representing the seconds and fractional seconds in the localized value of $date-time. Note that the value can be greater than 60 seconds to accommodate occasional leap seconds used to keep human time synchronized with the rotation of the planet.", new SequenceType[]{DATE_TIME_01_PARAM}, new FunctionReturnSequenceType(32, 3, "the seconds component from $date-time"));
    public static final FunctionSignature fnTimezoneFromDateTime = new FunctionSignature(new QName("timezone-from-dateTime", "http://www.w3.org/2005/xpath-functions"), "Returns the timezone component of $date-time if any. If $date-time has a timezone component, then the result is an xdt:dayTimeDuration that indicates deviation from UTC; its value may range from +14:00 to -14:00 hours, both inclusive. Otherwise, the result is the empty sequence.", new SequenceType[]{DATE_TIME_01_PARAM}, new FunctionReturnSequenceType(55, 3, "the timezone component from $date-time"));

    public FunGetDateComponent(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        if (args.length == 0 || args[0].isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            Sequence arg = args[0];
            AbstractDateTimeValue date = (AbstractDateTimeValue)arg.itemAt(0);
            if (this.isCalledAs("day-from-dateTime") || this.isCalledAs("day-from-date")) {
                result = new IntegerValue(date.getPart(2), 31);
            } else if (this.isCalledAs("month-from-dateTime") || this.isCalledAs("month-from-date")) {
                result = new IntegerValue(date.getPart(1), 31);
            } else if (this.isCalledAs("year-from-dateTime") || this.isCalledAs("year-from-date")) {
                result = new IntegerValue(date.getPart(0), 31);
            } else if (this.isCalledAs("hours-from-dateTime") || this.isCalledAs("hours-from-time")) {
                result = new IntegerValue(date.getPart(3), 31);
            } else if (this.isCalledAs("minutes-from-dateTime") || this.isCalledAs("minutes-from-time")) {
                result = new IntegerValue(date.getPart(4), 31);
            } else if (this.isCalledAs("seconds-from-dateTime") || this.isCalledAs("seconds-from-time")) {
                result = new IntegerValue(date.calendar.getSecond()).convertTo(32);
                if (date.calendar.getFractionalSecond() != null) {
                    result = ((DecimalValue)result).plus(new DecimalValue(date.calendar.getFractionalSecond()));
                }
            } else if (this.isCalledAs("timezone-from-dateTime") || this.isCalledAs("timezone-from-date") || this.isCalledAs("timezone-from-time")) {
                result = date.getTimezone();
            } else {
                logger.error("can't handle function " + this.mySignature.getName().getLocalPart());
                throw new Error("can't handle function " + this.mySignature.getName().getLocalPart());
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

