/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import org.exist.dom.QName;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.URIUtils;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class FunIRIToURI
extends Function {
    protected static final String FUNCTION_DESCRIPTION = "This function converts an xs:string containing an IRI into a URI according to the rules spelled out in Section 3.1 of [RFC 3987]. It is idempotent but not invertible.\n\nIf $iri contains a character that is invalid in an IRI, such as the space character (see note below), the invalid character is replaced by its percent-encoded form as described in [RFC 3986] before the conversion is performed.\n\nIf $iri is the empty sequence, returns the zero-length string.\n\nSince [RFC 3986] recommends that, for consistency, URI producers and normalizers should use uppercase hexadecimal digits for all percent-encodings, this function must always generate hexadecimal values using the upper-case letters A-F.\n\nNotes:\n\nThis function does not check whether $iri is a legal IRI. It treats it as an xs:string and operates on the characters in the xs:string.\n\nThe following printable ASCII characters are invalid in an IRI: \"<\", \">\", \" \" \" (double quote), space, \"{\", \"}\", \"|\", \"\\\", \"^\", and \"`\". Since these characters should not appear in an IRI, if they do appear in $iri they will be percent-encoded. In addition, characters outside the range x20-x126 will be percent-encoded because they are invalid in a URI.\n\nSince this function does not escape the PERCENT SIGN \"%\" and this character is not allowed in data within a URI, users wishing to convert character strings, such as file names, that include \"%\" to a URI should manually escape \"%\" by replacing it with \"%25\".";
    public static final FunctionSignature signature = new FunctionSignature(new QName("iri-to-uri", "http://www.w3.org/2005/xpath-functions"), "This function converts an xs:string containing an IRI into a URI according to the rules spelled out in Section 3.1 of [RFC 3987]. It is idempotent but not invertible.\n\nIf $iri contains a character that is invalid in an IRI, such as the space character (see note below), the invalid character is replaced by its percent-encoded form as described in [RFC 3986] before the conversion is performed.\n\nIf $iri is the empty sequence, returns the zero-length string.\n\nSince [RFC 3986] recommends that, for consistency, URI producers and normalizers should use uppercase hexadecimal digits for all percent-encodings, this function must always generate hexadecimal values using the upper-case letters A-F.\n\nNotes:\n\nThis function does not check whether $iri is a legal IRI. It treats it as an xs:string and operates on the characters in the xs:string.\n\nThe following printable ASCII characters are invalid in an IRI: \"<\", \">\", \" \" \" (double quote), space, \"{\", \"}\", \"|\", \"\\\", \"^\", and \"`\". Since these characters should not appear in an IRI, if they do appear in $iri they will be percent-encoded. In addition, characters outside the range x20-x126 will be percent-encoded because they are invalid in a URI.\n\nSince this function does not escape the PERCENT SIGN \"%\" and this character is not allowed in data within a URI, users wishing to convert character strings, such as file names, that include \"%\" to a URI should manually escape \"%\" by replacing it with \"%25\".", new SequenceType[]{new FunctionParameterSequenceType("iri", 22, 3, "The IRI")}, new FunctionReturnSequenceType(22, 2, "the URI"));

    public FunIRIToURI(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        StringValue result;
        Sequence seq;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if ((seq = this.getArgument(0).eval(contextSequence)).isEmpty()) {
            result = StringValue.EMPTY_STRING;
        } else {
            String value = URIUtils.iriToURI(seq.getStringValue());
            result = new StringValue(value);
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

