/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import org.exist.dom.QName;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.DoubleValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.ValueSequence;

public class FunInsertBefore
extends Function {
    protected static final String FUNCTION_DESCRIPTION = "Returns a new sequence constructed from the value of $target with the value of $inserts inserted at the position specified by the value of $position. (The value of $target is not affected by the sequence construction.)\n\nIf $target is the empty sequence, $inserts is returned. If $inserts is the empty sequence, $target is returned.\n\nThe value returned by the function consists of all items of $target whose index is less than $position, followed by all items of $inserts, followed by the remaining elements of $target, in that sequence.\n\nIf $position is less than one (1), the first position, the effective value of $position is one (1). If $position is greater than the number of items in $target, then the effective value of $position is equal to the number of items in $target plus 1.";
    public static final FunctionSignature signature = new FunctionSignature(new QName("insert-before", "http://www.w3.org/2005/xpath-functions"), "Returns a new sequence constructed from the value of $target with the value of $inserts inserted at the position specified by the value of $position. (The value of $target is not affected by the sequence construction.)\n\nIf $target is the empty sequence, $inserts is returned. If $inserts is the empty sequence, $target is returned.\n\nThe value returned by the function consists of all items of $target whose index is less than $position, followed by all items of $inserts, followed by the remaining elements of $target, in that sequence.\n\nIf $position is less than one (1), the first position, the effective value of $position is one (1). If $position is greater than the number of items in $target, then the effective value of $position is equal to the number of items in $target plus 1.", new SequenceType[]{new FunctionParameterSequenceType("target", 11, 7, "The target"), new FunctionParameterSequenceType("position", 31, 2, "The position to insert before"), new FunctionParameterSequenceType("inserts", 11, 7, "The data to insert")}, new FunctionReturnSequenceType(11, 7, "the new sequence"));

    public FunInsertBefore(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        Sequence seq1 = this.getArgument(0).eval(contextSequence, contextItem);
        Sequence seq2 = this.getArgument(2).eval(contextSequence, contextItem);
        if (seq1.isEmpty()) {
            result = seq2;
        } else if (seq2.isEmpty()) {
            result = seq1;
        } else {
            int pos = ((DoubleValue)this.getArgument(1).eval(contextSequence, contextItem).convertTo(34)).getInt();
            result = new ValueSequence();
            if (--pos <= 0) {
                result.addAll(seq2);
                result.addAll(seq1);
            } else if (pos >= seq1.getItemCount()) {
                result.addAll(seq1);
                result.addAll(seq2);
            } else {
                for (int i = 0; i < seq1.getItemCount(); ++i) {
                    if (i == pos) {
                        result.addAll(seq2);
                    }
                    result.add(seq1.itemAt(i));
                }
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

