/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import org.exist.dom.QName;
import org.exist.security.PermissionDeniedException;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;

public class FunLang
extends Function {
    private static final String queryString = "(ancestor-or-self::*/@xml:lang)[position() = last()]";
    public CompiledXQuery query;
    protected static final String FUNCTION_DESCRIPTION_1_PARAM = "Tests whether the language of the context item ";
    protected static final String FUNCTION_DESCRIPTION_2_PARAMS = "Tests whether the language of $node ";
    protected static final String FUNCTION_DESCRIPTION_BOTH = "as specified by xml:lang attributes is the same as, or is a sublanguage of, the language specified by $lang. The behavior of the function if the second argument is omitted is exactly the same as if the context item (.) had been passed as the second argument. The language of the argument node, or the context item if the second argument is omitted, is determined by the value of the xml:lang attribute on the node, or, if the node has no such attribute, by the value of the xml:lang attribute on the nearest ancestor of the node that has an xml:lang attribute. If there is no such ancestor, then the function returns false().\n\nThe following errors may be raised: if the context item is undefined [err:XPDY0002]XP; if the context item is not a node [err:XPTY0004]XP.\n\nIf $lang is the empty sequence it is interpreted as the zero-length string.";
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("lang", "http://www.w3.org/2005/xpath-functions"), "Tests whether the language of the context item as specified by xml:lang attributes is the same as, or is a sublanguage of, the language specified by $lang. The behavior of the function if the second argument is omitted is exactly the same as if the context item (.) had been passed as the second argument. The language of the argument node, or the context item if the second argument is omitted, is determined by the value of the xml:lang attribute on the node, or, if the node has no such attribute, by the value of the xml:lang attribute on the nearest ancestor of the node that has an xml:lang attribute. If there is no such ancestor, then the function returns false().\n\nThe following errors may be raised: if the context item is undefined [err:XPDY0002]XP; if the context item is not a node [err:XPTY0004]XP.\n\nIf $lang is the empty sequence it is interpreted as the zero-length string.", new SequenceType[]{new FunctionParameterSequenceType("lang", 22, 3, "The language code")}, new FunctionReturnSequenceType(23, 2, "true if the language code matches, false otherwise")), new FunctionSignature(new QName("lang", "http://www.w3.org/2005/xpath-functions"), "Tests whether the language of $node as specified by xml:lang attributes is the same as, or is a sublanguage of, the language specified by $lang. The behavior of the function if the second argument is omitted is exactly the same as if the context item (.) had been passed as the second argument. The language of the argument node, or the context item if the second argument is omitted, is determined by the value of the xml:lang attribute on the node, or, if the node has no such attribute, by the value of the xml:lang attribute on the nearest ancestor of the node that has an xml:lang attribute. If there is no such ancestor, then the function returns false().\n\nThe following errors may be raised: if the context item is undefined [err:XPDY0002]XP; if the context item is not a node [err:XPTY0004]XP.\n\nIf $lang is the empty sequence it is interpreted as the zero-length string.", new SequenceType[]{new FunctionParameterSequenceType("lang", 22, 3, "The language code"), new FunctionParameterSequenceType("node", -1, 2, "The node")}, new FunctionReturnSequenceType(23, 2, "true if the language code matches, false otherwise"))};

    public FunLang(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        super.analyze(contextInfo);
        try {
            this.query = this.context.getBroker().getBrokerPool().getXQueryService().compile(this.context.getBroker(), this.context, queryString);
        }
        catch (PermissionDeniedException e) {
            throw new XPathException((Expression)this, (Throwable)e);
        }
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        BooleanValue result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if (this.getArgumentCount() == 2) {
            contextSequence = this.getArgument(1).eval(contextSequence);
        }
        if (contextSequence == null) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Undefined context item");
        }
        if (!Type.subTypeOf(contextSequence.getItemType(), -1)) {
            throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "Context item is not a node");
        }
        String lang = this.getArgument(0).eval(contextSequence).getStringValue();
        Sequence seq = this.query.eval(contextSequence);
        if (seq.isEmpty()) {
            result = BooleanValue.FALSE;
        } else if (seq.hasOne()) {
            int hyphen;
            String langValue = seq.getStringValue();
            boolean include = lang.equalsIgnoreCase(langValue);
            if (!include && (hyphen = langValue.indexOf(45)) != -1) {
                langValue = langValue.substring(0, hyphen);
                include = lang.equalsIgnoreCase(langValue);
            }
            result = new BooleanValue(include);
        } else {
            throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "Sequence returned more than one item !");
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

