/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import org.exist.dom.QName;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class FunLast
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("last", "http://www.w3.org/2005/xpath-functions"), "Returns the context size from the dynamic context. If the context item is undefined, an error is raised.", null, new FunctionReturnSequenceType(31, 3, "the context size from the dynamic context"));

    public FunLast(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public int getDependencies() {
        if (this.inPredicate) {
            return 1;
        }
        return 17;
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence inSequence;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if ((inSequence = this.context.getContextSequence()) == null) {
            inSequence = contextSequence;
        }
        if (inSequence == null) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "undefined context item");
        }
        Sequence result = inSequence.isEmpty() ? Sequence.EMPTY_SEQUENCE : new IntegerValue(inSequence.getItemCount());
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

