/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.exist.EXistException;
import org.exist.dom.QName;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.ExtArrayNodeSet;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.NodeSet;
import org.exist.storage.NativeValueIndex;
import org.exist.util.PatternFactory;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Atomize;
import org.exist.xquery.BasicExpressionVisitor;
import org.exist.xquery.Dependency;
import org.exist.xquery.DynamicCardinalityCheck;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.GeneralComparison;
import org.exist.xquery.IndexUseReporter;
import org.exist.xquery.LocationStep;
import org.exist.xquery.NodeTest;
import org.exist.xquery.Optimizable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.pragmas.Optimize;
import org.exist.xquery.regex.RegexUtil;
import org.exist.xquery.util.Error;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;

public class FunMatches
extends Function
implements Optimizable,
IndexUseReporter {
    protected static final String FUNCTION_DESCRIPTION_1_PARAM = "The function returns true if $input matches the regular expression supplied as $pattern, if present; otherwise, it returns false.\n\n";
    protected static final String FUNCTION_DESCRIPTION_2_PARAM = "The function returns true if $input matches the regular expression supplied as $pattern as influenced by the value of $flags, if present; otherwise, it returns false.\n\nThe effect of calling this version of the function with the $flags argument set to a zero-length string is the same as using the other two argument version. Flags are defined in 7.6.1.1 Flags.\n\n";
    protected static final String FUNCTION_DESCRIPTION_COMMON = "If $input is the empty sequence, it is interpreted as the zero-length string.\n\nUnless the metacharacters ^ and $ are used as anchors, the string is considered to match the pattern if any substring matches the pattern. But if anchors are used, the anchors must match the start/end of the string (in string mode), or the start/end of a line (in multiline mode).\n\nNote:\n\nThis is different from the behavior of patterns in [XML Schema Part 2: Datatypes Second Edition], where regular expressions are implicitly anchored.\n\nPlease note that - in contrast - with the specification - this method allows zero or more items for the string argument.\n\nAn error is raised [err:FORX0002] if the value of $pattern is invalid according to the rules described in section 7.6.1 Regular Expression Syntax.\n\n";
    protected static final String FUNCTION_DESCRIPTION_2_PARAM_2 = "An error is raised [err:FORX0001] if the value of $flags is invalid according to the rules described in section 7.6.1 Regular Expression Syntax.";
    protected static final String FUNCTION_DESCRIPTION_REGEX = "If $input is the empty sequence, it is interpreted as the zero-length string.\n\nNote:\n\nThe text:matches-regex() variants of the fn:matches() functions are identical except that they avoid the translation of the specified regular expression from XPath2 to Java syntax. That is, the regular expression is evaluated as is, and must be valid according to Java regular expression syntax, rather than the more restrictive XPath2 syntax.";
    protected static final FunctionParameterSequenceType INPUT_ARG = new FunctionParameterSequenceType("input", 22, 7, "The input string");
    protected static final FunctionParameterSequenceType PATTERN_ARG = new FunctionParameterSequenceType("pattern", 22, 2, "The pattern");
    protected static final FunctionParameterSequenceType FLAGS_ARG = new FunctionParameterSequenceType("flags", 22, 2, "The flags");
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("matches", "http://www.w3.org/2005/xpath-functions"), "The function returns true if $input matches the regular expression supplied as $pattern, if present; otherwise, it returns false.\n\nIf $input is the empty sequence, it is interpreted as the zero-length string.\n\nUnless the metacharacters ^ and $ are used as anchors, the string is considered to match the pattern if any substring matches the pattern. But if anchors are used, the anchors must match the start/end of the string (in string mode), or the start/end of a line (in multiline mode).\n\nNote:\n\nThis is different from the behavior of patterns in [XML Schema Part 2: Datatypes Second Edition], where regular expressions are implicitly anchored.\n\nPlease note that - in contrast - with the specification - this method allows zero or more items for the string argument.\n\nAn error is raised [err:FORX0002] if the value of $pattern is invalid according to the rules described in section 7.6.1 Regular Expression Syntax.\n\n", new SequenceType[]{INPUT_ARG, PATTERN_ARG}, new FunctionReturnSequenceType(23, 2, "true if the pattern is a match, false otherwise")), new FunctionSignature(new QName("matches", "http://www.w3.org/2005/xpath-functions"), "The function returns true if $input matches the regular expression supplied as $pattern as influenced by the value of $flags, if present; otherwise, it returns false.\n\nThe effect of calling this version of the function with the $flags argument set to a zero-length string is the same as using the other two argument version. Flags are defined in 7.6.1.1 Flags.\n\nIf $input is the empty sequence, it is interpreted as the zero-length string.\n\nUnless the metacharacters ^ and $ are used as anchors, the string is considered to match the pattern if any substring matches the pattern. But if anchors are used, the anchors must match the start/end of the string (in string mode), or the start/end of a line (in multiline mode).\n\nNote:\n\nThis is different from the behavior of patterns in [XML Schema Part 2: Datatypes Second Edition], where regular expressions are implicitly anchored.\n\nPlease note that - in contrast - with the specification - this method allows zero or more items for the string argument.\n\nAn error is raised [err:FORX0002] if the value of $pattern is invalid according to the rules described in section 7.6.1 Regular Expression Syntax.\n\nAn error is raised [err:FORX0001] if the value of $flags is invalid according to the rules described in section 7.6.1 Regular Expression Syntax.", new SequenceType[]{INPUT_ARG, PATTERN_ARG, FLAGS_ARG}, new FunctionReturnSequenceType(23, 2, "true if the pattern is a match, false otherwise"))};
    protected Matcher matcher = null;
    protected Pattern pat = null;
    protected boolean hasUsedIndex = false;
    private LocationStep contextStep = null;
    private QName contextQName = null;
    private int axis = -1;
    private NodeSet preselectResult = null;
    private GeneralComparison.IndexFlags idxflags = new GeneralComparison.IndexFlags();

    public FunMatches(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public void setArguments(List<Expression> arguments) throws XPathException {
        List<LocationStep> steps;
        Expression arg;
        this.steps.clear();
        Expression path = arguments.get(0);
        this.steps.add(path);
        if (arguments.size() >= 2) {
            arg = arguments.get(1);
            if (!Type.subTypeOf((arg = new DynamicCardinalityCheck(this.context, 2, arg, new Error("D02", "2", this.mySignature))).returnsType(), 20)) {
                arg = new Atomize(this.context, arg);
            }
            this.steps.add(arg);
        }
        if (arguments.size() >= 3) {
            arg = arguments.get(2);
            if (!Type.subTypeOf((arg = new DynamicCardinalityCheck(this.context, 2, arg, new Error("D02", "3", this.mySignature))).returnsType(), 20)) {
                arg = new Atomize(this.context, arg);
            }
            this.steps.add(arg);
        }
        if (!(steps = BasicExpressionVisitor.findLocationSteps(path)).isEmpty()) {
            NodeTest test;
            LocationStep firstStep = steps.get(0);
            LocationStep lastStep = steps.get(steps.size() - 1);
            if (firstStep != null && lastStep != null && !(test = lastStep.getTest()).isWildcardTest() && test.getName() != null) {
                this.contextQName = lastStep.getAxis() == 6 || lastStep.getAxis() == 13 ? new QName(test.getName(), 1) : new QName(test.getName());
                this.contextStep = lastStep;
                this.axis = firstStep.getAxis();
                if (this.axis == 12 && steps.size() > 1) {
                    if (steps.get(1) != null) {
                        this.axis = steps.get(1).getAxis();
                    } else {
                        this.contextQName = null;
                        this.contextStep = null;
                        this.axis = -1;
                    }
                }
            }
        }
    }

    @Override
    public boolean canOptimize(Sequence contextSequence) {
        if (this.contextQName == null) {
            return false;
        }
        return Type.subTypeOf(Optimize.getQNameIndexType(this.context, contextSequence, this.contextQName), 22);
    }

    @Override
    public boolean optimizeOnSelf() {
        return false;
    }

    @Override
    public boolean optimizeOnChild() {
        return false;
    }

    @Override
    public int getOptimizeAxis() {
        return this.axis;
    }

    @Override
    public NodeSet preSelect(Sequence contextSequence, boolean useContext) throws XPathException {
        String pattern;
        boolean caseSensitive;
        int flags;
        long start = System.currentTimeMillis();
        this.preselectResult = null;
        int indexType = Optimize.getQNameIndexType(this.context, contextSequence, this.contextQName);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Using QName index on type " + Type.getTypeName(indexType));
        }
        if (this.getSignature().getArgumentCount() == 3) {
            String flagsArg = this.getArgument(2).eval(contextSequence).getStringValue();
            flags = RegexUtil.parseFlags(this, flagsArg);
        } else {
            flags = 0;
        }
        boolean bl = caseSensitive = !RegexUtil.hasCaseInsensitive(flags);
        if (this.isCalledAs("matches-regex")) {
            pattern = this.getArgument(1).eval(contextSequence).getStringValue();
        } else {
            boolean literal = RegexUtil.hasLiteral(flags);
            if (literal) {
                pattern = this.getArgument(1).eval(contextSequence).getStringValue();
            } else {
                boolean ignoreWhitespace = RegexUtil.hasIgnoreWhitespace(flags);
                boolean caseBlind = !caseSensitive;
                pattern = RegexUtil.translateRegexp(this, this.getArgument(1).eval(contextSequence).getStringValue(), ignoreWhitespace, caseBlind);
            }
        }
        try {
            this.preselectResult = this.context.getBroker().getValueIndex().match(this.context.getWatchDog(), contextSequence.getDocumentSet(), useContext ? contextSequence.toNodeSet() : null, 1, pattern, this.contextQName, 1, flags, caseSensitive);
            this.hasUsedIndex = true;
        }
        catch (EXistException e) {
            throw new XPathException((Expression)this, "Error during index lookup: " + e.getMessage(), (Throwable)e);
        }
        if (this.context.getProfiler().traceFunctions()) {
            this.context.getProfiler().traceIndexUsage(this.context, "range", this, 2, System.currentTimeMillis() - start);
        }
        return this.preselectResult;
    }

    @Override
    public int getDependencies() {
        Expression stringArg = this.getArgument(0);
        Expression patternArg = this.getArgumentCount() >= 2 ? this.getArgument(1) : null;
        if (!(!Type.subTypeOf(stringArg.returnsType(), -1) || Dependency.dependsOn(stringArg, 2) || patternArg != null && Dependency.dependsOn(patternArg, 2))) {
            return 1;
        }
        return 3;
    }

    @Override
    public int returnsType() {
        if (this.inPredicate && (this.getDependencies() & 2) == 0) {
            return -1;
        }
        return 23;
    }

    @Override
    public boolean hasUsedIndex() {
        return this.hasUsedIndex;
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        AnalyzeContextInfo newContextInfo = new AnalyzeContextInfo(contextInfo);
        newContextInfo.setParent(this);
        this.inPredicate = (newContextInfo.getFlags() & 2) > 0;
        for (int i = 0; i < this.getArgumentCount(); ++i) {
            this.getArgument(i).analyze(newContextInfo);
        }
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        long start = System.currentTimeMillis();
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (this.preselectResult != null && this.preselectResult.isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if (this.contextStep == null || this.preselectResult == null) {
            Sequence input = this.getArgument(0).eval(contextSequence, contextItem);
            if (input.isPersistentSet() && this.inPredicate && !Dependency.dependsOn(this, 2)) {
                if (this.context.isProfilingEnabled()) {
                    this.context.getProfiler().message((Expression)this, 3, "", "Index evaluation");
                }
                result = input.isEmpty() ? Sequence.EMPTY_SEQUENCE : this.evalWithIndex(contextSequence, contextItem, input);
                if (this.context.getProfiler().traceFunctions()) {
                    this.context.getProfiler().traceIndexUsage(this.context, "range", this, 1, System.currentTimeMillis() - start);
                }
            } else {
                if (this.context.isProfilingEnabled()) {
                    this.context.getProfiler().message((Expression)this, 3, "", "Generic evaluation");
                }
                result = input.isEmpty() ? BooleanValue.FALSE : this.evalGeneric(contextSequence, contextItem, input);
                if (this.context.getProfiler().traceFunctions()) {
                    this.context.getProfiler().traceIndexUsage(this.context, "range", this, 0, System.currentTimeMillis() - start);
                }
            }
        } else {
            this.contextStep.setPreloadedData(contextSequence.getDocumentSet(), this.preselectResult);
            result = this.getArgument(0).eval(contextSequence).toNodeSet();
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    private Sequence evalWithIndex(Sequence contextSequence, Item contextItem, Sequence input) throws XPathException {
        String pattern;
        int flags;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (this.getSignature().getArgumentCount() == 3) {
            String flagsArg = this.getArgument(2).eval(contextSequence, contextItem).getStringValue();
            flags = RegexUtil.parseFlags(this, flagsArg);
        } else {
            flags = 0;
        }
        boolean caseSensitive = !RegexUtil.hasCaseInsensitive(flags);
        Sequence result = null;
        if (this.isCalledAs("matches-regex")) {
            pattern = this.getArgument(1).eval(contextSequence, contextItem).getStringValue();
        } else {
            boolean literal = RegexUtil.hasLiteral(flags);
            if (literal) {
                pattern = this.getArgument(1).eval(contextSequence, contextItem).getStringValue();
            } else {
                boolean ignoreWhitespace = RegexUtil.hasIgnoreWhitespace(flags);
                boolean caseBlind = !caseSensitive;
                pattern = RegexUtil.translateRegexp(this, this.getArgument(1).eval(contextSequence, contextItem).getStringValue(), ignoreWhitespace, caseBlind);
            }
        }
        NodeSet nodes = input.toNodeSet();
        int indexType = nodes.getIndexType();
        if (LOG.isTraceEnabled()) {
            LOG.trace("found an index of type: " + Type.getTypeName(indexType));
        }
        if (Type.subTypeOf(indexType, 22)) {
            boolean indexScan = false;
            if (contextSequence != null) {
                GeneralComparison.IndexFlags iflags = GeneralComparison.checkForQNameIndex(this.idxflags, this.context, contextSequence, this.contextQName);
                boolean indexFound = false;
                if (!iflags.indexOnQName()) {
                    indexFound = this.contextQName != null;
                    this.contextQName = null;
                }
                if (!indexFound && this.contextQName == null && iflags.hasIndexOnQNames()) {
                    indexScan = true;
                }
            } else {
                result = this.evalFallback(nodes, pattern, flags, indexType);
            }
            if (result == null) {
                DocumentSet docs = nodes.getDocumentSet();
                try {
                    NativeValueIndex index = this.context.getBroker().getValueIndex();
                    this.hasUsedIndex = true;
                    if (this.context.isProfilingEnabled()) {
                        this.context.getProfiler().message((Expression)this, 2, "Using vlaue index '" + index.toString() + "'", "Regex: " + pattern);
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Using range index for fn:matches expression: " + pattern);
                    }
                    if (indexScan) {
                        result = index.matchAll(this.context.getWatchDog(), docs, nodes, 0, pattern, 1, flags, caseSensitive);
                    }
                    result = index.match(this.context.getWatchDog(), docs, nodes, 0, pattern, this.contextQName, 1, flags, caseSensitive);
                }
                catch (EXistException e) {
                    throw new XPathException((Expression)this, (Throwable)e);
                }
            }
        } else {
            result = this.evalFallback(nodes, pattern, flags, indexType);
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    private Sequence evalFallback(NodeSet nodes, String pattern, int flags, int indexType) throws XPathException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("fn:matches: can't use existing range index of type " + Type.getTypeName(indexType) + ". Need a string index.");
        }
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        for (NodeProxy node : nodes) {
            if (!this.match(node.getStringValue(), pattern, flags)) continue;
            result.add((Item)node);
        }
        return result;
    }

    private Sequence evalGeneric(Sequence contextSequence, Item contextItem, Sequence stringArg) throws XPathException {
        String pattern;
        String string = stringArg.getStringValue();
        int flags = this.getSignature().getArgumentCount() == 3 ? RegexUtil.parseFlags(this, this.getArgument(2).eval(contextSequence, contextItem).getStringValue()) : 0;
        if (this.isCalledAs("matches-regex")) {
            pattern = this.getArgument(1).eval(contextSequence, contextItem).getStringValue();
        } else {
            boolean literal = RegexUtil.hasLiteral(flags);
            if (literal) {
                pattern = this.getArgument(1).eval(contextSequence, contextItem).getStringValue();
            } else {
                boolean ignoreWhitespace = RegexUtil.hasIgnoreWhitespace(flags);
                boolean caseBlind = RegexUtil.hasCaseInsensitive(flags);
                pattern = RegexUtil.translateRegexp(this, this.getArgument(1).eval(contextSequence, contextItem).getStringValue(), ignoreWhitespace, caseBlind);
            }
        }
        return BooleanValue.valueOf(this.match(string, pattern, flags));
    }

    private boolean match(String string, String pattern, int flags) throws XPathException {
        try {
            if (this.pat == null || !pattern.equals(this.pat.pattern()) || flags != this.pat.flags()) {
                this.pat = PatternFactory.getInstance().getPattern(pattern, flags);
                this.matcher = this.pat.matcher(string);
            } else {
                this.matcher.reset(string);
            }
            return this.matcher.find();
        }
        catch (PatternSyntaxException e) {
            throw new XPathException(this, ErrorCodes.FORX0001, "Invalid regular expression: " + e.getMessage(), new StringValue(pattern), e);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.hasUsedIndex = false;
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        if (!postOptimization) {
            this.preselectResult = null;
        }
    }
}

