/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import org.exist.dom.INode;
import org.exist.dom.QName;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.w3c.dom.Node;

public class FunName
extends Function {
    private static final String FUNCTION_DESCRIPTION_0_PARAM = "Returns the name of the context item as an xs:string that is either the zero-length string, or has the lexical form of an xs:QName.\n\n";
    private static final String FUNCTION_DESCRIPTION_1_PARAM = "Returns the name of $arg as an xs:string that is either the zero-length string, or has the lexical form of an xs:QName.\n\nIf the argument is omitted, it defaults to the context item (.). ";
    private static final String FUNCTION_DESCRIPTION_COMMON = "The behavior of the function if the argument is omitted is exactly the same as if the context item had been passed as the argument.\n\nThe following errors may be raised: if the context item is undefined [err:XPDY0002]XP; if the context item is not a node [err:XPTY0004]XP.\n\nIf the argument is supplied and is the empty sequence, the function returns the zero-length string.\n\nIf the target node has no name (that is, if it is a document node, a comment, a text node, or a namespace binding having no name), the function returns the zero-length string.\n\nOtherwise, the value returned is fn:string(fn:node-name($arg)).";
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("name", "http://www.w3.org/2005/xpath-functions"), "Returns the name of the context item as an xs:string that is either the zero-length string, or has the lexical form of an xs:QName.\n\nThe behavior of the function if the argument is omitted is exactly the same as if the context item had been passed as the argument.\n\nThe following errors may be raised: if the context item is undefined [err:XPDY0002]XP; if the context item is not a node [err:XPTY0004]XP.\n\nIf the argument is supplied and is the empty sequence, the function returns the zero-length string.\n\nIf the target node has no name (that is, if it is a document node, a comment, a text node, or a namespace binding having no name), the function returns the zero-length string.\n\nOtherwise, the value returned is fn:string(fn:node-name($arg)).", new SequenceType[0], new FunctionReturnSequenceType(22, 3, "the name")), new FunctionSignature(new QName("name", "http://www.w3.org/2005/xpath-functions"), "Returns the name of $arg as an xs:string that is either the zero-length string, or has the lexical form of an xs:QName.\n\nIf the argument is omitted, it defaults to the context item (.). The behavior of the function if the argument is omitted is exactly the same as if the context item had been passed as the argument.\n\nThe following errors may be raised: if the context item is undefined [err:XPDY0002]XP; if the context item is not a node [err:XPTY0004]XP.\n\nIf the argument is supplied and is the empty sequence, the function returns the zero-length string.\n\nIf the target node has no name (that is, if it is a document node, a comment, a text node, or a namespace binding having no name), the function returns the zero-length string.\n\nOtherwise, the value returned is fn:string(fn:node-name($arg)).", new SequenceType[]{new FunctionParameterSequenceType("arg", -1, 3, "The input node")}, new FunctionReturnSequenceType(22, 3, "the name"))};

    public FunName(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        StringValue result;
        Sequence seq;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if ((seq = this.getSignature().getArgumentCount() > 0 ? this.getArgument(0).eval(contextSequence, contextItem) : contextSequence) == null) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Undefined context item");
        }
        if (seq.isEmpty()) {
            result = StringValue.EMPTY_STRING;
        } else {
            Item item = seq.itemAt(0);
            if (!Type.subTypeOf(item.getType(), -1)) {
                throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "item is not a node; got '" + Type.getTypeName(item.getType()) + "'");
            }
            Node n = ((NodeValue)item).getNode();
            result = n instanceof INode ? new StringValue(((INode)n).getQName().getStringValue()) : StringValue.EMPTY_STRING;
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

