/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import org.exist.dom.QName;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;
import org.w3c.dom.Node;

public class FunNamespaceURI
extends Function {
    private static final String FUNCTION_DESCRIPTION_0_PARAM = "Returns the namespace URI of the xs:QName of the context item.\n\n";
    private static final String FUNCTION_DESCRIPTION_1_PARAM = "Returns the namespace URI of the xs:QName of $arg.\n\nIf the argument is omitted, it defaults to the context node (.). ";
    private static final String FUNCTION_DESCRIPTION_COMMON = "The behavior of the function if the argument is omitted is exactly the same as if the context item had been passed as the argument.\n\nThe following errors may be raised: if the context item is undefined [err:XPDY0002]XP; if the context item is not a node [err:XPTY0004]XP.\n\nIf $arg is neither an element nor an attribute node, or if it is an element or attribute node whose expanded-QName (as determined by the dm:node-name accessor in the Section 5.11 node-name AccessorDM) is in no namespace, then the function returns the xs:anyURI corresponding to the zero-length string.";
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("namespace-uri", "http://www.w3.org/2005/xpath-functions"), "Returns the namespace URI of the xs:QName of the context item.\n\nThe behavior of the function if the argument is omitted is exactly the same as if the context item had been passed as the argument.\n\nThe following errors may be raised: if the context item is undefined [err:XPDY0002]XP; if the context item is not a node [err:XPTY0004]XP.\n\nIf $arg is neither an element nor an attribute node, or if it is an element or attribute node whose expanded-QName (as determined by the dm:node-name accessor in the Section 5.11 node-name AccessorDM) is in no namespace, then the function returns the xs:anyURI corresponding to the zero-length string.", new SequenceType[0], (SequenceType)new FunctionReturnSequenceType(25, 2, "the namespace URI"), false), new FunctionSignature(new QName("namespace-uri", "http://www.w3.org/2005/xpath-functions"), "Returns the namespace URI of the xs:QName of $arg.\n\nIf the argument is omitted, it defaults to the context node (.). The behavior of the function if the argument is omitted is exactly the same as if the context item had been passed as the argument.\n\nThe following errors may be raised: if the context item is undefined [err:XPDY0002]XP; if the context item is not a node [err:XPTY0004]XP.\n\nIf $arg is neither an element nor an attribute node, or if it is an element or attribute node whose expanded-QName (as determined by the dm:node-name accessor in the Section 5.11 node-name AccessorDM) is in no namespace, then the function returns the xs:anyURI corresponding to the zero-length string.", new SequenceType[]{new FunctionParameterSequenceType("arg", -1, 3, "The input node")}, (SequenceType)new FunctionReturnSequenceType(25, 2, "the namespace URI"), false)};

    public FunNamespaceURI(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        AnyURIValue result;
        Sequence seq;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if ((seq = this.getSignature().getArgumentCount() > 0 ? this.getArgument(0).eval(contextSequence, contextItem) : contextSequence) == null) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Undefined context item");
        }
        if (seq.isEmpty()) {
            result = AnyURIValue.EMPTY_URI;
        } else {
            Item item = seq.itemAt(0);
            if (!Type.subTypeOf(item.getType(), -1)) {
                throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "Context item is not a node; got: " + Type.getTypeName(item.getType()));
            }
            Node n = ((NodeValue)item).getNode();
            String ns = n.getNamespaceURI();
            if (ns == null) {
                ns = "";
            }
            result = new AnyURIValue(ns);
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

