/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import java.util.StringTokenizer;
import org.exist.dom.QName;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class FunNormalizeSpace
extends Function {
    private static final String FUNCTION_DESCRIPTION_0_PARAM = "Returns the calculated string value of the context item with whitespace normalized by stripping leading ";
    protected static final String FUNCTION_DESCRIPTION_1_PARAM = "Returns the value of $arg with whitespace normalized by stripping leading ";
    private static final String FUNCTION_DESCRIPTION_COMMON_1 = "and trailing whitespace and replacing sequences of one or more than one whitespace character with a single space, #x20.\n\nThe whitespace characters are defined in the metasymbol S (Production 3) of [Extensible Markup Language (XML) 1.0 Recommendation (Third Edition)].\n\nNote:\n\nThe definition of the metasymbol S (Production 3), is unchanged in [Extensible Markup Language (XML) 1.1 Recommendation].\n\n";
    private static final String FUNCTION_DESCRIPTION_1_PARAM_1 = "If the value of $arg is the empty sequence, returns the zero-length string.\n\n";
    private static final String FUNCTION_DESCRIPTION_COMMON_2 = "If no argument is supplied, $arg defaults to the string value (calculated using fn:string()) of the context item (.). If no argument is supplied or if the argument is the context item and the context item is undefined an error is raised: [err:XPDY0002].";
    private static final FunctionReturnSequenceType RETURN_TYPE = new FunctionReturnSequenceType(22, 2, "the normalized text");
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("normalize-space", "http://www.w3.org/2005/xpath-functions"), "Returns the calculated string value of the context item with whitespace normalized by stripping leading and trailing whitespace and replacing sequences of one or more than one whitespace character with a single space, #x20.\n\nThe whitespace characters are defined in the metasymbol S (Production 3) of [Extensible Markup Language (XML) 1.0 Recommendation (Third Edition)].\n\nNote:\n\nThe definition of the metasymbol S (Production 3), is unchanged in [Extensible Markup Language (XML) 1.1 Recommendation].\n\nIf no argument is supplied, $arg defaults to the string value (calculated using fn:string()) of the context item (.). If no argument is supplied or if the argument is the context item and the context item is undefined an error is raised: [err:XPDY0002].", new SequenceType[0], RETURN_TYPE), new FunctionSignature(new QName("normalize-space", "http://www.w3.org/2005/xpath-functions"), "Returns the value of $arg with whitespace normalized by stripping leading and trailing whitespace and replacing sequences of one or more than one whitespace character with a single space, #x20.\n\nThe whitespace characters are defined in the metasymbol S (Production 3) of [Extensible Markup Language (XML) 1.0 Recommendation (Third Edition)].\n\nNote:\n\nThe definition of the metasymbol S (Production 3), is unchanged in [Extensible Markup Language (XML) 1.1 Recommendation].\n\nIf the value of $arg is the empty sequence, returns the zero-length string.\n\nIf no argument is supplied, $arg defaults to the string value (calculated using fn:string()) of the context item (.). If no argument is supplied or if the argument is the context item and the context item is undefined an error is raised: [err:XPDY0002].", new SequenceType[]{new FunctionParameterSequenceType("arg", 22, 3, "The string to normalize")}, RETURN_TYPE)};

    public FunNormalizeSpace(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public int returnsType() {
        return 22;
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        String value = null;
        if (this.getSignature().getArgumentCount() == 0) {
            if (contextSequence == null) {
                throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Undefined context item");
            }
            value = !contextSequence.isEmpty() ? contextSequence.itemAt(0).getStringValue() : "";
        } else {
            Sequence seq = this.getArgument(0).eval(contextSequence);
            if (seq == null) {
                throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Undefined context item");
            }
            if (!seq.isEmpty()) {
                value = seq.getStringValue();
            }
        }
        StringValue result = value == null ? StringValue.EMPTY_STRING : new StringValue(FunNormalizeSpace.normalize(value));
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    protected static String normalize(String str) {
        StringBuilder buf = new StringBuilder();
        if (!str.isEmpty()) {
            StringTokenizer tok = new StringTokenizer(str);
            while (tok.hasMoreTokens()) {
                buf.append(tok.nextToken());
                if (!tok.hasMoreTokens()) continue;
                buf.append(' ');
            }
        }
        return buf.toString();
    }
}

