/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import org.exist.dom.QName;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.NodeSet;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;

public class FunNot
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("not", "http://www.w3.org/2005/xpath-functions"), " Returns true if the effective boolean value is false, and false if the effective boolean value is true. \n\n $arg is reduced to an effective boolean value by applying the fn:boolean() function.", new SequenceType[]{new FunctionParameterSequenceType("arg", 11, 7, "The input items")}, new FunctionReturnSequenceType(23, 2, "the negated effective boolean value (ebv) of $arg"));
    private boolean inWhereClause = false;

    public FunNot(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        super.analyze(contextInfo);
        this.inWhereClause = (contextInfo.getFlags() & 4) != 0;
    }

    @Override
    public int returnsType() {
        return Type.subTypeOf(this.getArgument(0).returnsType(), -1) ? -1 : 23;
    }

    @Override
    public int getDependencies() {
        return 1 | this.getArgument(0).getDependencies();
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        Expression arg;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if (Type.subTypeOf((arg = this.getArgument(0)).returnsType(), -1) && (contextSequence == null || contextSequence.isPersistentSet()) && !Dependency.dependsOn(arg, 2)) {
            if (contextSequence == null || contextSequence.isEmpty()) {
                result = this.evalBoolean(contextSequence, contextItem, arg);
            } else {
                result = contextSequence.toNodeSet().copy();
                if (this.inPredicate) {
                    SequenceIterator i = result.iterate();
                    while (i.hasNext()) {
                        NodeProxy item = (NodeProxy)i.nextItem();
                        if (this.contextId != -1) {
                            item.addContextNode(this.contextId, item);
                            continue;
                        }
                        item.addContextNode(this.getExpressionId(), item);
                    }
                }
                Sequence argSeq = arg.eval(result);
                NodeSet argSet = this.contextId != -1 ? argSeq.toNodeSet().getContextNodes(this.contextId) : argSeq.toNodeSet().getContextNodes(this.getExpressionId());
                result = ((NodeSet)result).except(argSet);
            }
        } else {
            return this.evalBoolean(contextSequence, contextItem, arg);
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    private Sequence evalBoolean(Sequence contextSequence, Item contextItem, Expression arg) throws XPathException {
        Sequence seq = arg.eval(contextSequence, contextItem);
        return seq.effectiveBooleanValue() ? BooleanValue.FALSE : BooleanValue.TRUE;
    }
}

