/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import org.exist.dom.QName;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.ExternalModule;
import org.exist.xquery.FunctionCall;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.InlineFunction;
import org.exist.xquery.Module;
import org.exist.xquery.NamedFunctionReference;
import org.exist.xquery.UserDefinedFunction;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReference;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.QNameValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FunOnFunctions
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("function-lookup", "http://www.w3.org/2005/xpath-functions"), "Returns a reference to the function having a given name and arity, if there is one, the empty sequence otherwise", new SequenceType[]{new FunctionParameterSequenceType("name", 24, 2, "Qualified name of the function"), new FunctionParameterSequenceType("arity", 31, 2, "The arity (number of arguments) of the function")}, new FunctionReturnSequenceType(101, 3, "The function if found, empty sequence otherwise")), new FunctionSignature(new QName("function-name", "http://www.w3.org/2005/xpath-functions"), "Returns the name of the function identified by a function item.", new SequenceType[]{new FunctionParameterSequenceType("function", 101, 2, "The function item")}, new FunctionReturnSequenceType(24, 3, "The name of the function or the empty sequence if $function is an anonymous function.")), new FunctionSignature(new QName("function-arity", "http://www.w3.org/2005/xpath-functions"), "Returns the arity of the function identified by a function item.", new SequenceType[]{new FunctionParameterSequenceType("function", 101, 2, "The function item")}, new FunctionReturnSequenceType(31, 2, "The arity of the function."))};

    public FunOnFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        super.analyze(contextInfo);
        if (this.getContext().getXQueryVersion() < 30) {
            throw new XPathException((Expression)this, ErrorCodes.EXXQDY0003, "Function '" + this.getSignature().getName() + "' is only supported for xquery version \"3.0\" and later.");
        }
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        try {
            if (this.isCalledAs("function-lookup")) {
                FunctionCall call;
                QName fname = ((QNameValue)args[0].itemAt(0)).getQName();
                int arity = ((IntegerValue)args[1].itemAt(0)).getInt();
                try {
                    call = NamedFunctionReference.lookupFunction(this, this.context, fname, arity);
                }
                catch (XPathException e) {
                    if (e.getErrorCode() == ErrorCodes.XPST0017) {
                        return Sequence.EMPTY_SEQUENCE;
                    }
                    throw e;
                }
                return call == null ? Sequence.EMPTY_SEQUENCE : new FunctionReference(call);
            }
            if (this.isCalledAs("function-name")) {
                FunctionReference ref = (FunctionReference)args[0].itemAt(0);
                QName qname = ref.getSignature().getName();
                if (qname == null || qname == InlineFunction.INLINE_FUNCTION_QNAME) {
                    return Sequence.EMPTY_SEQUENCE;
                }
                return new QNameValue(this.context, qname);
            }
            FunctionReference ref = (FunctionReference)args[0].itemAt(0);
            return new IntegerValue(ref.getSignature().getArgumentCount());
        }
        catch (Exception e) {
            if (e instanceof XPathException) {
                throw (XPathException)e;
            }
            throw new XPathException((Expression)this, ErrorCodes.XPST0017, e.getMessage());
        }
    }

    public static FunctionCall lookupFunction(Expression parent, QName qname, int arity) throws XPathException {
        Module module = parent.getContext().getModule(qname.getNamespaceURI());
        try {
            UserDefinedFunction func;
            if (module == null) {
                func = parent.getContext().resolveFunction(qname, arity);
            } else {
                if (module.isInternalModule()) {
                    throw new XPathException(parent, ErrorCodes.XPST0017, "Cannot create a reference to an internal Java function");
                }
                func = ((ExternalModule)module).getFunction(qname, arity, parent.getContext());
            }
            if (func == null) {
                return null;
            }
            FunctionCall funcCall = new FunctionCall(parent.getContext(), func);
            funcCall.setLocation(parent.getLine(), parent.getColumn());
            return funcCall;
        }
        catch (XPathException e) {
            return null;
        }
    }
}

