/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.exist.dom.QName;
import org.exist.util.PatternFactory;
import org.exist.xquery.Atomize;
import org.exist.xquery.Dependency;
import org.exist.xquery.DynamicCardinalityCheck;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.fn.FunMatches;
import org.exist.xquery.regex.RegexUtil;
import org.exist.xquery.util.Error;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;

public class FunReplace
extends FunMatches {
    private static final String FUNCTION_DESCRIPTION_3_PARAM = "The function returns the xs:string that is obtained by replacing each non-overlapping substring of $input that matches the given $pattern with an occurrence of the $replacement string.\n\n";
    private static final String FUNCTION_DESCRIPTION_4_PARAM = "The function returns the xs:string that is obtained by replacing each non-overlapping substring of $input that matches the given $pattern with an occurrence of the $replacement string.\n\nThe $flags argument is interpreted in the same manner as for the fn:matches() function.\n\nCalling the four argument version with the $flags argument set to a zero-length string gives the same effect as using the three argument version.\n\n";
    private static final String FUNCTION_DESCRIPTION_COMMON = "If $input is the empty sequence, it is interpreted as the zero-length string.\n\nIf two overlapping substrings of $input both match the $pattern, then only the first one (that is, the one whose first character comes first in the $input string) is replaced.\n\nWithin the $replacement string, a variable $N may be used to refer to the substring captured by the Nth parenthesized sub-expression in the regular expression. For each match of the pattern, these variables are assigned the value of the content matched by the relevant sub-expression, and the modified replacement string is then substituted for the characters in $input that matched the pattern. $0 refers to the substring captured by the regular expression as a whole.\n\nMore specifically, the rules are as follows, where S is the number of parenthesized sub-expressions in the regular expression, and N is the decimal number formed by taking all the digits that consecutively follow the $ character:\n\n1.  If N=0, then the variable is replaced by the substring matched by the regular expression as a whole.\n\n2.  If 1<=N<=S, then the variable is replaced by the substring captured by the Nth parenthesized sub-expression. If the Nth parenthesized sub-expression was not matched, then the variable is replaced by the zero-length string.\n\n3.  If S<N<=9, then the variable is replaced by the zero-length string.\n\n4.  Otherwise (if N>S and N>9), the last digit of N is taken to be a literal character to be included \"as is\" in the replacement string, and the rules are reapplied using the number N formed by stripping off this last digit.";
    protected static final FunctionParameterSequenceType INPUT_ARG = new FunctionParameterSequenceType("input", 22, 3, "The input string");
    protected static final FunctionParameterSequenceType PATTERN_ARG = new FunctionParameterSequenceType("pattern", 22, 2, "The pattern to match");
    protected static final FunctionParameterSequenceType REPLACEMENT_ARG = new FunctionParameterSequenceType("replacement", 22, 2, "The string to replace the pattern with");
    protected static final FunctionParameterSequenceType FLAGS_ARG = new FunctionParameterSequenceType("flags", 22, 2, "The flags");
    protected static final FunctionReturnSequenceType RETURN_TYPE = new FunctionReturnSequenceType(22, 3, "the altered string");
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("replace", "http://www.w3.org/2005/xpath-functions"), "The function returns the xs:string that is obtained by replacing each non-overlapping substring of $input that matches the given $pattern with an occurrence of the $replacement string.\n\nIf $input is the empty sequence, it is interpreted as the zero-length string.\n\nIf two overlapping substrings of $input both match the $pattern, then only the first one (that is, the one whose first character comes first in the $input string) is replaced.\n\nWithin the $replacement string, a variable $N may be used to refer to the substring captured by the Nth parenthesized sub-expression in the regular expression. For each match of the pattern, these variables are assigned the value of the content matched by the relevant sub-expression, and the modified replacement string is then substituted for the characters in $input that matched the pattern. $0 refers to the substring captured by the regular expression as a whole.\n\nMore specifically, the rules are as follows, where S is the number of parenthesized sub-expressions in the regular expression, and N is the decimal number formed by taking all the digits that consecutively follow the $ character:\n\n1.  If N=0, then the variable is replaced by the substring matched by the regular expression as a whole.\n\n2.  If 1<=N<=S, then the variable is replaced by the substring captured by the Nth parenthesized sub-expression. If the Nth parenthesized sub-expression was not matched, then the variable is replaced by the zero-length string.\n\n3.  If S<N<=9, then the variable is replaced by the zero-length string.\n\n4.  Otherwise (if N>S and N>9), the last digit of N is taken to be a literal character to be included \"as is\" in the replacement string, and the rules are reapplied using the number N formed by stripping off this last digit.", new SequenceType[]{INPUT_ARG, PATTERN_ARG, REPLACEMENT_ARG}, RETURN_TYPE), new FunctionSignature(new QName("replace", "http://www.w3.org/2005/xpath-functions"), "The function returns the xs:string that is obtained by replacing each non-overlapping substring of $input that matches the given $pattern with an occurrence of the $replacement string.\n\nThe $flags argument is interpreted in the same manner as for the fn:matches() function.\n\nCalling the four argument version with the $flags argument set to a zero-length string gives the same effect as using the three argument version.\n\nIf $input is the empty sequence, it is interpreted as the zero-length string.\n\nIf two overlapping substrings of $input both match the $pattern, then only the first one (that is, the one whose first character comes first in the $input string) is replaced.\n\nWithin the $replacement string, a variable $N may be used to refer to the substring captured by the Nth parenthesized sub-expression in the regular expression. For each match of the pattern, these variables are assigned the value of the content matched by the relevant sub-expression, and the modified replacement string is then substituted for the characters in $input that matched the pattern. $0 refers to the substring captured by the regular expression as a whole.\n\nMore specifically, the rules are as follows, where S is the number of parenthesized sub-expressions in the regular expression, and N is the decimal number formed by taking all the digits that consecutively follow the $ character:\n\n1.  If N=0, then the variable is replaced by the substring matched by the regular expression as a whole.\n\n2.  If 1<=N<=S, then the variable is replaced by the substring captured by the Nth parenthesized sub-expression. If the Nth parenthesized sub-expression was not matched, then the variable is replaced by the zero-length string.\n\n3.  If S<N<=9, then the variable is replaced by the zero-length string.\n\n4.  Otherwise (if N>S and N>9), the last digit of N is taken to be a literal character to be included \"as is\" in the replacement string, and the rules are reapplied using the number N formed by stripping off this last digit.", new SequenceType[]{INPUT_ARG, PATTERN_ARG, REPLACEMENT_ARG, FLAGS_ARG}, RETURN_TYPE)};

    public FunReplace(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public void setArguments(List<Expression> arguments) throws XPathException {
        this.steps.clear();
        Expression arg = arguments.get(0);
        arg = new DynamicCardinalityCheck(this.context, 3, arg, new Error("D02", "1", this.mySignature));
        if (!Type.subTypeOf(arg.returnsType(), 20)) {
            arg = new Atomize(this.context, arg);
        }
        this.steps.add(arg);
        arg = arguments.get(1);
        arg = new DynamicCardinalityCheck(this.context, 2, arg, new Error("D02", "2", this.mySignature));
        if (!Type.subTypeOf(arg.returnsType(), 20)) {
            arg = new Atomize(this.context, arg);
        }
        this.steps.add(arg);
        arg = arguments.get(2);
        arg = new DynamicCardinalityCheck(this.context, 2, arg, new Error("D02", "3", this.mySignature));
        if (!Type.subTypeOf(arg.returnsType(), 20)) {
            arg = new Atomize(this.context, arg);
        }
        this.steps.add(arg);
        if (arguments.size() == 4) {
            arg = arguments.get(3);
            if (!Type.subTypeOf((arg = new DynamicCardinalityCheck(this.context, 2, arg, new Error("D02", "4", this.mySignature))).returnsType(), 20)) {
                arg = new Atomize(this.context, arg);
            }
            this.steps.add(arg);
        }
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        StringValue result;
        Sequence stringArg;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if ((stringArg = this.getArgument(0).eval(contextSequence, contextItem)).isEmpty()) {
            result = StringValue.EMPTY_STRING;
        } else {
            String pattern;
            int flags = this.getSignature().getArgumentCount() == 4 ? RegexUtil.parseFlags(this, this.getArgument(3).eval(contextSequence, contextItem).getStringValue()) : 0;
            String string = stringArg.getStringValue();
            Sequence patternSeq = this.getArgument(1).eval(contextSequence, contextItem);
            Sequence replaceSeq = this.getArgument(2).eval(contextSequence, contextItem);
            String replace = replaceSeq.getStringValue();
            if (RegexUtil.hasLiteral(flags)) {
                pattern = patternSeq.getStringValue();
                replace = replace.replace("\\", "\\\\").replace("$", "\\$");
            } else {
                pattern = RegexUtil.translateRegexp(this, patternSeq.getStringValue(), RegexUtil.hasIgnoreWhitespace(flags), RegexUtil.hasCaseInsensitive(flags));
            }
            for (int i = 0; i < replace.length(); ++i) {
                if (replace.charAt(i) != '\\') continue;
                try {
                    if (replace.charAt(i + 1) != '\\' && replace.charAt(i + 1) != '$') {
                        throw new XPathException(this, ErrorCodes.FORX0004, "The value of $replacement contains a '\\' character that is not part of a '\\\\' pair, unless it is immediately followed by a '$' character.", replaceSeq);
                    }
                    ++i;
                    continue;
                }
                catch (Exception e) {
                    throw new XPathException(this, ErrorCodes.FORX0004, "The value of $replacement contains a '\\' character that is not part of a '\\\\' pair, unless it is immediately followed by a '$' character.", replaceSeq);
                }
            }
            try {
                if (this.pat == null || !pattern.equals(this.pat.pattern()) || flags != this.pat.flags()) {
                    this.pat = PatternFactory.getInstance().getPattern(pattern, flags);
                    this.matcher = this.pat.matcher(string);
                } else {
                    this.matcher.reset(string);
                }
                String r = this.matcher.replaceAll(replace);
                result = new StringValue(r);
            }
            catch (PatternSyntaxException e) {
                throw new XPathException(this, ErrorCodes.FORX0001, "Invalid regular expression: " + e.getMessage(), patternSeq, e);
            }
            catch (IndexOutOfBoundsException e) {
                throw new XPathException(this, ErrorCodes.FORX0001, e.getMessage(), patternSeq, e);
            }
            catch (IllegalArgumentException e) {
                throw new XPathException(this, ErrorCodes.FORX0004, "Invalid replace expression: " + e.getMessage(), replaceSeq, e);
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

