/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import org.exist.dom.QName;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.ValueSequence;

public class FunReverse
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("reverse", "http://www.w3.org/2005/xpath-functions"), "Reverses the order of items in a sequence.  If the argument is an emptysequence, the empty sequence is returned.", new SequenceType[]{new FunctionParameterSequenceType("arg", 11, 7, "The sequence to reverse")}, new FunctionReturnSequenceType(11, 7, "the reverse order sequence"));

    public FunReverse(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        this.checkArguments();
        this.inPredicate = (contextInfo.getFlags() & 2) > 0;
        this.contextId = contextInfo.getContextId();
        contextInfo.setParent(this);
        AnalyzeContextInfo argContextInfo = new AnalyzeContextInfo(contextInfo);
        this.getArgument(0).analyze(argContextInfo);
        contextInfo.setStaticReturnType(argContextInfo.getStaticReturnType());
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        Sequence seq;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if ((seq = this.getArguments(contextSequence, contextItem)[0]).isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            ValueSequence tmp = new ValueSequence();
            SequenceIterator i = seq.iterate();
            while (i.hasNext()) {
                Item item = i.nextItem();
                tmp.add(item);
            }
            result = new ValueSequence();
            for (int i2 = seq.getItemCount() - 1; i2 >= 0; --i2) {
                result.add(tmp.itemAt(i2));
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

