/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import org.exist.dom.QName;
import org.exist.dom.memtree.DocumentImpl;
import org.exist.dom.memtree.NodeImpl;
import org.exist.dom.persistent.ExtArrayNodeSet;
import org.exist.dom.persistent.NodeProxy;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AbstractSequence;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;

public class FunRoot
extends Function {
    protected static final String FUNCTION_DESCRIPTION_0_PARAM = "Returns the root of the tree to which the context item belongs. ";
    protected static final String FUNCTION_DESCRIPTION_1_PARAM = "Returns the root of the tree to which $arg belongs. This will usually, but not necessarily, be a document node.\n\nIf $arg is the empty sequence, the empty sequence is returned.\n\nIf $arg is a document node, $arg is returned.\n\n The behavior of the zero argument version of the function is exactly the same as if the context item had been passed in $arg.";
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("root", "http://www.w3.org/2005/xpath-functions"), "Returns the root of the tree to which the context item belongs. ", new SequenceType[0], new FunctionReturnSequenceType(-1, 2, "the root node of the tree to which the context node belongs")), new FunctionSignature(new QName("root", "http://www.w3.org/2005/xpath-functions"), "Returns the root of the tree to which $arg belongs. This will usually, but not necessarily, be a document node.\n\nIf $arg is the empty sequence, the empty sequence is returned.\n\nIf $arg is a document node, $arg is returned.\n\n The behavior of the zero argument version of the function is exactly the same as if the context item had been passed in $arg.", new SequenceType[]{new FunctionParameterSequenceType("arg", -1, 3, "The input node")}, new FunctionReturnSequenceType(-1, 3, "the root node of the tree to which $arg belongs"))};

    public FunRoot(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence seq;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if (contextSequence == null || contextSequence.isEmpty()) {
            Sequence sequence = Sequence.EMPTY_SEQUENCE;
        }
        if ((seq = this.getSignature().getArgumentCount() > 0 ? this.getArgument(0).eval(contextSequence, contextItem) : contextSequence) == null) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Undefined context item");
        }
        AbstractSequence result = seq.isPersistentSet() ? new ExtArrayNodeSet(seq.getItemCount()) : new ValueSequence(seq.getItemCount());
        SequenceIterator i = seq.iterate();
        while (i.hasNext()) {
            Item item = i.nextItem();
            if (!Type.subTypeOf(item.getType(), -1)) {
                throw new XPathException(this, ErrorCodes.XPTY0004, "Item is not a node; got '" + item + "'", seq);
            }
            Sequence s = item.toSequence();
            if (s.isPersistentSet()) {
                NodeProxy p = s.toNodeSet().get(0);
                result.add(new NodeProxy(p.getOwnerDocument()));
                continue;
            }
            if (seq.hasOne() && item.getType() == 2) {
                result.add(item);
                continue;
            }
            if (item.getType() == 6) {
                result.add((DocumentImpl)item);
                continue;
            }
            result.add(((NodeImpl)item).getOwnerDocument());
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

