/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Properties;
import org.exist.dom.QName;
import org.exist.dom.memtree.DocumentBuilderReceiver;
import org.exist.dom.memtree.DocumentImpl;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.util.serializer.XQuerySerializer;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.fn.FnModule;
import org.exist.xquery.functions.map.MapType;
import org.exist.xquery.util.SerializerUtils;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class FunSerialize
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("serialize", "http://www.w3.org/2005/xpath-functions", ""), "This function serializes the supplied input sequence $arg as described in XSLT and XQuery Serialization 3.0, returning the serialized representation of the sequence as a string.", new SequenceType[]{new FunctionParameterSequenceType("args", 11, 7, "The node set to serialize")}, new FunctionParameterSequenceType("result", 22, 2, "the string containing the serialized node set.")), new FunctionSignature(new QName("serialize", "http://www.w3.org/2005/xpath-functions", ""), "This function serializes the supplied input sequence $arg as described in XSLT and XQuery Serialization 3.0, returning the serialized representation of the sequence as a string.", new SequenceType[]{new FunctionParameterSequenceType("args", 11, 7, "The node set to serialize"), new FunctionParameterSequenceType("parameters", 11, 3, "The serialization parameters as either a output:serialization-parameters element or a map")}, new FunctionParameterSequenceType("result", 22, 2, "the string containing the serialized node set."))};

    public FunSerialize(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Properties outputProperties;
        if (this.getArgumentCount() == 2 && !args[1].isEmpty()) {
            Item parametersItem = args[1].itemAt(0);
            if (parametersItem.getType() == 102) {
                outputProperties = SerializerUtils.getSerializationOptions(this, (MapType)args[1].itemAt(0));
            } else {
                if (!FunSerialize.isSerializationParametersElement(parametersItem)) throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "The parameters element must be either a output:serialization-parameters element or a map");
                outputProperties = new Properties();
                SerializerUtils.getSerializationOptions(this, (NodeValue)args[1].itemAt(0), outputProperties);
            }
        } else {
            outputProperties = new Properties();
        }
        try (StringWriter writer = new StringWriter();){
            XQuerySerializer xqSerializer = new XQuerySerializer(this.context.getBroker(), outputProperties, writer);
            Sequence seq = args[0];
            if (xqSerializer.normalize()) {
                seq = this.normalize(seq);
            }
            xqSerializer.serialize(seq);
            StringValue stringValue = new StringValue(writer.toString());
            return stringValue;
        }
        catch (IOException | SAXException e) {
            throw new XPathException((Expression)this, FnModule.SENR0001, e.getMessage());
        }
    }

    private static boolean isSerializationParametersElement(Item item) {
        if (item.getType() == 1) {
            Element element = (Element)((Object)item);
            return "http://www.w3.org/2010/xslt-xquery-serialization".equals(element.getNamespaceURI()) && "serialization-parameters".equals(element.getLocalName());
        }
        return false;
    }

    protected Sequence normalize(Sequence input) throws XPathException {
        if (input.isEmpty()) {
            return StringValue.EMPTY_STRING;
        }
        ValueSequence temp = new ValueSequence(input.getItemCount());
        SequenceIterator i = input.iterate();
        while (i.hasNext()) {
            Item next = i.nextItem();
            if (Type.subTypeOf(next.getType(), -1)) {
                if (next.getType() == 2 || next.getType() == 500 || next.getType() == 101) {
                    throw new XPathException((Expression)this, FnModule.SENR0001, "It is an error if an item in the sequence to serialize is an attribute node or a namespace node.");
                }
                temp.add(next);
                continue;
            }
            Item last = null;
            if (!temp.isEmpty()) {
                last = temp.itemAt(temp.getItemCount() - 1);
            }
            if (last != null && last.getType() == 22) {
                ((StringValue)last).append(" " + next.getStringValue());
                continue;
            }
            temp.add(new StringValue(next.getStringValue()));
        }
        this.context.pushDocumentContext();
        try {
            MemTreeBuilder builder = this.context.getDocumentBuilder();
            DocumentBuilderReceiver receiver = new DocumentBuilderReceiver(builder, true);
            SequenceIterator i2 = temp.iterate();
            while (i2.hasNext()) {
                Item next = i2.nextItem();
                if (Type.subTypeOf(next.getType(), -1)) {
                    next.copyTo(this.context.getBroker(), receiver);
                    continue;
                }
                receiver.characters(next.getStringValue());
            }
            DocumentImpl documentImpl = (DocumentImpl)receiver.getDocument();
            return documentImpl;
        }
        catch (SAXException e) {
            throw new XPathException((Expression)this, FnModule.SENR0001, e.getMessage());
        }
        finally {
            this.context.popDocumentContext();
        }
    }
}

