/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class FunStringJoin
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("string-join", "http://www.w3.org/2005/xpath-functions"), "Returns a xs:string created by concatenating the members of the $arg sequence using $separator as a separator. If the value of the separator is the zero-length string, then the members of the sequence are concatenated without a separator. The effect of calling the single-argument version of this function is the same as calling the two-argument version with $separator set to a zero-length string.", new SequenceType[]{new FunctionParameterSequenceType("arg", 22, 7, "The sequence to be joined to form the string. If it is empty, a zero-length string is returned.")}, new FunctionReturnSequenceType(22, 2, "the joined string")), new FunctionSignature(new QName("string-join", "http://www.w3.org/2005/xpath-functions"), "Returns a xs:string created by concatenating the members of the $arg sequence using $separator as a separator. If the value of the separator is the zero-length string, then the members of the sequence are concatenated without a separator.", new SequenceType[]{new FunctionParameterSequenceType("arg", 22, 7, "The sequence to be joined to form the string. If it is empty, a zero-length string is returned."), new FunctionParameterSequenceType("separator", 22, 2, "The separator to be placed in the string between the items of $arg")}, new FunctionReturnSequenceType(22, 2, "the joined string"))};

    public FunStringJoin(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        String sep = null;
        if (this.getArgumentCount() == 2 && (sep = args[1].getStringValue()).length() == 0) {
            sep = null;
        }
        StringBuilder out = new StringBuilder();
        boolean gotOne = false;
        SequenceIterator i = args[0].iterate();
        while (i.hasNext()) {
            Item next = i.nextItem();
            if (gotOne && sep != null) {
                out.append(sep);
            }
            out.append(next.getStringValue());
            gotOne = true;
        }
        StringValue result = new StringValue(out.toString());
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

