/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import org.exist.dom.QName;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

@Deprecated
public class FunStringPad
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("string-pad", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:string consisting of a number copies of $arg concatenated together without any separators. The number of copies is specified by $count.", new SequenceType[]{new FunctionParameterSequenceType("arg", 22, 3, "The string to be duplicated"), new FunctionParameterSequenceType("count", 31, 2, "The number of copies of $arg to be returned")}, (SequenceType)new FunctionReturnSequenceType(22, 3, "the duplicated string"), "fn:string-pad(...) is not part of the W3C specification.");

    public FunStringPad(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        Sequence seq;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if ((seq = this.getArgument(0).eval(contextSequence, contextItem)).isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            String str = seq.getStringValue();
            int count = ((IntegerValue)this.getArgument(1).eval(contextSequence, contextItem).convertTo(31)).getInt();
            if (count < 0) {
                throw new XPathException((Expression)this, "Invalid string-pad count");
            }
            if (count == 0) {
                result = StringValue.EMPTY_STRING;
            } else {
                StringBuilder buf = new StringBuilder(str.length() * count);
                for (int i = 0; i < count; ++i) {
                    buf.append(str);
                }
                result = new StringValue(buf.toString());
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

