/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import org.exist.dom.QName;
import org.exist.util.XMLChar;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.ValueSequence;

public class FunStringToCodepoints
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("string-to-codepoints", "http://www.w3.org/2005/xpath-functions"), "Returns the sequence of unicode code points that constitute an xs:string. If $arg is a zero-length string or the empty sequence, the empty sequence is returned.", new SequenceType[]{new FunctionParameterSequenceType("arg", 22, 3, "The input string")}, new FunctionReturnSequenceType(31, 7, "the sequence of code points"));

    public FunStringToCodepoints(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        Sequence result = args[0].isEmpty() ? Sequence.EMPTY_SEQUENCE : FunStringToCodepoints.getCodePoints(args[0].getStringValue());
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    public static ValueSequence getCodePoints(String s) {
        ValueSequence codepoints = new ValueSequence();
        for (int i = 0; i < s.length(); ++i) {
            IntegerValue next;
            char ch = s.charAt(i);
            if (XMLChar.isSurrogate(ch)) {
                int supp = XMLChar.supplemental(ch, s.charAt(++i));
                next = new IntegerValue(supp);
            } else {
                next = new IntegerValue(ch);
            }
            codepoints.add(next);
        }
        return codepoints;
    }

    public static int getCodePointCount(String s) {
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (XMLChar.isSurrogate(ch)) {
                ++i;
            }
            ++count;
        }
        return count;
    }

    public static String subSequence(ValueSequence seq, int start) throws XPathException {
        StringBuilder substring = new StringBuilder(seq.getItemCount());
        try {
            int i;
            int n = i = start >= 0 ? start : 0;
            while (i < seq.getItemCount()) {
                int ch = ((IntegerValue)seq.itemAt(i)).getInt();
                if (XMLChar.isSupplemental(ch)) {
                    substring.append(XMLChar.highSurrogate(ch));
                    substring.append(XMLChar.lowSurrogate(ch));
                } else {
                    substring.append((char)ch);
                }
                ++i;
            }
        }
        catch (XPathException e) {
            throw new XPathException("FunStringCodepoints.subSequence()/2 failure" + e.getMessage());
        }
        return substring.toString();
    }

    public static String subSequence(ValueSequence seq, int start, int end) throws XPathException {
        StringBuilder substring = new StringBuilder(seq.getItemCount());
        if (seq.getItemCount() < end) {
            return FunStringToCodepoints.subSequence(seq, start);
        }
        try {
            int i;
            int n = i = start >= 0 ? start : 0;
            while (i < end) {
                int ch = ((IntegerValue)seq.itemAt(i)).getInt();
                if (XMLChar.isSupplemental(ch)) {
                    substring.append(XMLChar.highSurrogate(ch));
                    substring.append(XMLChar.lowSurrogate(ch));
                } else {
                    substring.append((char)ch);
                }
                ++i;
            }
        }
        catch (XPathException e) {
            throw new XPathException("FunStringCodepoints.subSequence()/3 failure" + e.getMessage());
        }
        return substring.toString();
    }

    public static String codePointToString(IntegerValue value) throws XPathException {
        StringBuilder string = new StringBuilder(2);
        try {
            int intValue = value.getInt();
            if (XMLChar.isSupplemental(intValue)) {
                string.append(XMLChar.highSurrogate(intValue));
                string.append(XMLChar.lowSurrogate(intValue));
            } else {
                string.append((char)intValue);
            }
        }
        catch (XPathException e) {
            throw new XPathException("FunStringCodepoints.codePointToString()/1 failure" + e.getMessage());
        }
        return string.toString();
    }

    public static int indexOf(ValueSequence seq, IntegerValue value) {
        int index = -1;
        for (int i = 0; i < seq.getItemCount(); ++i) {
            if (value.compareTo(seq.itemAt(i)) != 0) continue;
            return i;
        }
        return -1;
    }
}

