/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import org.exist.dom.QName;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.DoubleValue;
import org.exist.xquery.value.DurationValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;

public class FunSum
extends Function {
    private boolean gotInfinity = false;
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("sum", "http://www.w3.org/2005/xpath-functions"), "Returns a value obtained by adding together the values in $arg. If $arg is the the empty sequence the xs:double value 0.0e0 is returned.", new SequenceType[]{new FunctionParameterSequenceType("arg", 20, 7, "The sequence of numbers to be summed up")}, new FunctionReturnSequenceType(20, 2, "the sum of all numbers in $arg")), new FunctionSignature(new QName("sum", "http://www.w3.org/2005/xpath-functions"), "Returns a value obtained by adding together the values in $arg. If $arg is the the empty sequence then $default is returned.", new SequenceType[]{new FunctionParameterSequenceType("arg", 20, 7, "The sequence of numbers to be summed up"), new FunctionParameterSequenceType("default", 20, 3, "The default value if $arg computes to the empty sequence")}, new FunctionReturnSequenceType(20, 2, "the sum of all numbers in $arg"))};

    public FunSum(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        ComputableValue result;
        Sequence inner;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if ((inner = this.getArgument(0).eval(contextSequence, contextItem)).isEmpty()) {
            Sequence zero = IntegerValue.ZERO;
            if (this.getSignature().getArgumentCount() == 2) {
                zero = this.getArgument(1).eval(contextSequence, contextItem);
            }
            result = zero;
        } else {
            SequenceIterator iter = inner.iterate();
            Item item = iter.nextItem();
            AtomicValue value = item.atomize();
            value = this.check(value, null);
            ComputableValue sum = (ComputableValue)value;
            while (iter.hasNext()) {
                item = iter.nextItem();
                value = item.atomize();
                if (Type.subTypeOf((value = this.check(value, sum)).getType(), 30)) {
                    if (((NumericValue)value).isInfinite()) {
                        this.gotInfinity = true;
                    }
                    if (((NumericValue)value).isNaN()) {
                        sum = DoubleValue.NaN;
                        break;
                    }
                }
                sum = (ComputableValue)sum.promote(value);
                sum = sum.plus((ComputableValue)value);
            }
            result = sum;
        }
        if (this.gotInfinity || !Type.subTypeOf(result.getItemType(), 30) || ((NumericValue)result).isInfinite()) {
            // empty if block
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AtomicValue check(AtomicValue value, ComputableValue sum) throws XPathException {
        if (Type.subTypeOf(value.getType(), 53)) {
            if ((value = ((DurationValue)value).wrap()).getType() == 54) {
                if (sum != null && sum.getType() != 54) {
                    throw new XPathException(this, ErrorCodes.FORG0006, "Cannot compare " + Type.getTypeName(sum.getType()) + " and " + Type.getTypeName(value.getType()), value);
                }
            } else {
                if (value.getType() != 55) throw new XPathException(this, ErrorCodes.FORG0006, "Cannot compare " + Type.getTypeName(value.getType()), value);
                if (sum != null && sum.getType() != 55) {
                    throw new XPathException(this, ErrorCodes.FORG0006, "Cannot compare " + Type.getTypeName(sum.getType()) + " and " + Type.getTypeName(value.getType()), value);
                }
            }
        } else if (value.getType() == 21) {
            value = value.convertTo(34);
        }
        if (value instanceof ComputableValue) return value;
        throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "" + Type.getTypeName(value.getType()) + "(" + value + ")' can not be an operand in a sum");
    }
}

