/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import java.util.regex.PatternSyntaxException;
import org.exist.dom.QName;
import org.exist.util.PatternFactory;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionDSL;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.fn.FunMatches;
import org.exist.xquery.functions.fn.FunNormalizeSpace;
import org.exist.xquery.regex.RegexUtil;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;

public class FunTokenize
extends FunMatches {
    private static final QName FS_TOKENIZE_NAME = new QName("tokenize", "http://www.w3.org/2005/xpath-functions");
    private static final FunctionParameterSequenceType FS_TOKENIZE_PARAM_INPUT = FunctionDSL.optParam("input", 22, "The input string");
    private static final FunctionParameterSequenceType FS_TOKENIZE_PARAM_PATTERN = FunctionDSL.param("pattern", 22, "The tokenization pattern");
    public static final FunctionSignature[] FS_TOKENIZE = FunctionDSL.functionSignatures(FS_TOKENIZE_NAME, "Breaks the input string $input into a sequence of strings, ", FunctionDSL.returnsOptMany(22, "the token sequence"), FunctionDSL.arities(FunctionDSL.arity(FS_TOKENIZE_PARAM_INPUT), FunctionDSL.arity(FS_TOKENIZE_PARAM_INPUT, FS_TOKENIZE_PARAM_PATTERN), FunctionDSL.arity(FS_TOKENIZE_PARAM_INPUT, FS_TOKENIZE_PARAM_PATTERN, FunctionDSL.param("flags", 22, "The flags"))));

    public FunTokenize(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        Sequence stringArg;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if ((stringArg = this.getArgument(0).eval(contextSequence, contextItem)).isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            String string = stringArg.getStringValue();
            if (string.isEmpty()) {
                result = Sequence.EMPTY_SEQUENCE;
            } else {
                String pattern;
                int flags = this.getSignature().getArgumentCount() == 3 ? RegexUtil.parseFlags(this, this.getArgument(2).eval(contextSequence, contextItem).getStringValue()) : 0;
                if (this.getArgumentCount() == 1) {
                    pattern = " ";
                    string = FunNormalizeSpace.normalize(string);
                } else if (RegexUtil.hasLiteral(flags)) {
                    pattern = this.getArgument(1).eval(contextSequence, contextItem).getStringValue();
                } else {
                    boolean ignoreWhitespace = RegexUtil.hasIgnoreWhitespace(flags);
                    boolean caseBlind = !RegexUtil.hasCaseInsensitive(flags);
                    pattern = RegexUtil.translateRegexp(this, this.getArgument(1).eval(contextSequence, contextItem).getStringValue(), ignoreWhitespace, caseBlind);
                }
                try {
                    if (this.pat == null || !pattern.equals(this.pat.pattern()) || flags != this.pat.flags()) {
                        this.pat = PatternFactory.getInstance().getPattern(pattern, flags);
                    }
                    if (this.pat.matcher("").matches()) {
                        throw new XPathException((Expression)this, ErrorCodes.FORX0003, "regular expression could match empty string");
                    }
                    String[] tokens = this.pat.split(string, -1);
                    result = new ValueSequence();
                    for (String token : tokens) {
                        result.add(new StringValue(token));
                    }
                }
                catch (PatternSyntaxException e) {
                    throw new XPathException(this, ErrorCodes.FORX0001, "Invalid regular expression: " + e.getMessage(), new StringValue(pattern), e);
                }
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

