/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.exist.dom.QName;
import org.exist.security.PermissionDeniedException;
import org.exist.source.Source;
import org.exist.source.SourceFactory;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionDSL;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;

public class FunUnparsedText
extends BasicFunction {
    private static final FunctionParameterSequenceType PARAM_HREF = FunctionDSL.optParam("href", 22, "the URI to load text from");
    private static final FunctionParameterSequenceType PARAM_ENCODING = FunctionDSL.param("encoding", 22, "character encoding of the resource");
    static final FunctionSignature[] FS_UNPARSED_TEXT = FunctionDSL.functionSignatures(new QName("unparsed-text", "http://www.w3.org/2005/xpath-functions"), "reads an external resource (for example, a file) and returns a string representation of the resource", FunctionDSL.returnsOpt(22), FunctionDSL.arities(FunctionDSL.arity(PARAM_HREF), FunctionDSL.arity(PARAM_HREF, PARAM_ENCODING)));
    static final FunctionSignature[] FS_UNPARSED_TEXT_LINES = FunctionDSL.functionSignatures(new QName("unparsed-text-lines", "http://www.w3.org/2005/xpath-functions"), "reads an external resource (for example, a file) and returns its contents as a sequence of strings, one for each line of text in the string representation of the resource", FunctionDSL.returnsOptMany(22), FunctionDSL.arities(FunctionDSL.arity(PARAM_HREF), FunctionDSL.arity(PARAM_HREF, PARAM_ENCODING)));
    static final FunctionSignature[] FS_UNPARSED_TEXT_AVAILABLE = FunctionDSL.functionSignatures(new QName("unparsed-text-available", "http://www.w3.org/2005/xpath-functions"), "determines whether a call on the fn:unparsed-text function with identical arguments would return a string", FunctionDSL.returnsOpt(22), FunctionDSL.arities(FunctionDSL.arity(PARAM_HREF), FunctionDSL.arity(PARAM_HREF, PARAM_ENCODING)));

    public FunUnparsedText(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String encoding;
        String string = encoding = args.length == 2 ? args[1].getStringValue() : null;
        if (!args[0].isEmpty()) {
            String content;
            if (this.isCalledAs("unparsed-text-lines")) {
                return this.readLines(args[0].getStringValue(), encoding);
            }
            try {
                content = this.readContent(args[0].getStringValue(), encoding);
            }
            catch (XPathException e) {
                if (this.isCalledAs("unparsed-text-available")) {
                    return BooleanValue.FALSE;
                }
                throw e;
            }
            if (this.isCalledAs("unparsed-text-available")) {
                return BooleanValue.TRUE;
            }
            return new StringValue(content);
        }
        return Sequence.EMPTY_SEQUENCE;
    }

    private String readContent(String uriParam, String encoding) throws XPathException {
        try {
            Source source = this.getSource(uriParam);
            Charset charset = this.getCharset(encoding, source);
            StringWriter output = new StringWriter();
            try (InputStream is = source.getInputStream();){
                IOUtils.copy((InputStream)is, (Writer)output, (Charset)charset);
            }
            return output.toString();
        }
        catch (IOException e) {
            throw new XPathException((Expression)this, ErrorCodes.FOUT1170, e.getMessage());
        }
    }

    private Sequence readLines(String uriParam, String encoding) throws XPathException {
        try {
            ValueSequence result = new ValueSequence();
            Source source = this.getSource(uriParam);
            Charset charset = this.getCharset(encoding, source);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(source.getInputStream(), charset));){
                String line;
                while ((line = reader.readLine()) != null) {
                    result.add(new StringValue(line));
                }
            }
            return result;
        }
        catch (IOException e) {
            throw new XPathException((Expression)this, ErrorCodes.FOUT1170, e.getMessage());
        }
    }

    private Charset getCharset(String encoding, Source source) throws XPathException {
        Charset charset;
        if (encoding == null) {
            try {
                charset = source.getEncoding();
            }
            catch (IOException e) {
                throw new XPathException((Expression)this, ErrorCodes.FOUT1170, e.getMessage());
            }
            if (charset == null) {
                charset = StandardCharsets.UTF_8;
            }
        } else {
            try {
                charset = Charset.forName(encoding);
            }
            catch (IllegalArgumentException e) {
                throw new XPathException((Expression)this, ErrorCodes.FOUT1190, e.getMessage());
            }
        }
        return charset;
    }

    private Source getSource(String uriParam) throws XPathException {
        try {
            URI uri = new URI(uriParam);
            if (uri.getScheme() == null) {
                uri = new URI("xmldb:exist://" + uriParam);
            }
            if (uri.getFragment() != null) {
                throw new XPathException((Expression)this, ErrorCodes.FOUT1170, "href argument may not contain fragment identifier");
            }
            Source source = SourceFactory.getSource(this.context.getBroker(), "", uri.toASCIIString(), false);
            if (!this.context.getBroker().getCurrentSubject().hasDbaRole()) {
                throw new XPathException((Expression)this, ErrorCodes.FOUT1170, "non-dba user not allowed to read from file system");
            }
            return source;
        }
        catch (IOException | URISyntaxException | PermissionDeniedException e) {
            throw new XPathException((Expression)this, ErrorCodes.FOUT1170, e.getMessage());
        }
    }
}

