/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import org.exist.dom.QName;
import org.exist.security.PermissionDeniedException;
import org.exist.source.Source;
import org.exist.source.SourceFactory;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.array.ArrayType;
import org.exist.xquery.functions.map.MapType;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class JSON
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("parse-json", "http://www.w3.org/2005/xpath-functions"), "Parses a string supplied in the form of a JSON text, returning the results typically in the form of a map or array.", new SequenceType[]{new FunctionParameterSequenceType("json-text", 22, 3, "JSON string")}, new FunctionReturnSequenceType(11, 3, "The parsed data, typically a map, array or atomic value")), new FunctionSignature(new QName("parse-json", "http://www.w3.org/2005/xpath-functions"), "Parses a string supplied in the form of a JSON text, returning the results typically in the form of a map or array.", new SequenceType[]{new FunctionParameterSequenceType("json-text", 22, 3, "JSON string"), new FunctionParameterSequenceType("options", 102, 2, "Parsing options")}, new FunctionReturnSequenceType(11, 3, "The parsed data, typically a map, array or atomic value")), new FunctionSignature(new QName("json-doc", "http://www.w3.org/2005/xpath-functions"), "Reads an external (or database) resource containing JSON, and returns the results of parsing the resource as JSON. An URL parameter without scheme or scheme 'xmldb:' is considered to point to a database resource.", new SequenceType[]{new FunctionParameterSequenceType("href", 22, 3, "URL pointing to a JSON resource")}, new FunctionReturnSequenceType(11, 3, "The parsed data, typically a map, array or atomic value")), new FunctionSignature(new QName("json-doc", "http://www.w3.org/2005/xpath-functions"), "Reads an external (or database) resource containing JSON, and returns the results of parsing the resource as JSON. An URL parameter without scheme or scheme 'xmldb:' is considered to point to a database resource.", new SequenceType[]{new FunctionParameterSequenceType("href", 22, 3, "URL pointing to a JSON resource"), new FunctionParameterSequenceType("options", 102, 2, "Parsing options")}, new FunctionReturnSequenceType(11, 3, "The parsed data, typically a map, array or atomic value"))};
    public static final String OPTION_DUPLICATES = "duplicates";
    public static final String OPTION_DUPLICATES_REJECT = "reject";
    public static final String OPTION_DUPLICATES_USE_FIRST = "use-first";
    public static final String OPTION_DUPLICATES_USE_LAST = "use-last";
    public static final String OPTION_LIBERAL = "liberal";
    public static final String OPTION_UNESCAPE = "unescape";

    public JSON(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (this.context.getXQueryVersion() < 31) {
            throw new XPathException((Expression)this, ErrorCodes.EXXQDY0004, "json functions only available in XQuery 3.1, but version declaration states " + this.context.getXQueryVersion());
        }
        boolean liberal = false;
        String handleDuplicates = OPTION_DUPLICATES_USE_LAST;
        if (this.getArgumentCount() == 2) {
            Sequence duplicateOpt;
            MapType options = (MapType)args[1].itemAt(0);
            Sequence liberalOpt = options.get(new StringValue(OPTION_LIBERAL));
            if (liberalOpt.hasOne()) {
                liberal = liberalOpt.itemAt(0).convertTo(23).effectiveBooleanValue();
            }
            if ((duplicateOpt = options.get(new StringValue(OPTION_DUPLICATES))).hasOne()) {
                handleDuplicates = duplicateOpt.itemAt(0).getStringValue();
            }
        }
        JsonFactory factory = new JsonFactory();
        factory.configure(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS, true);
        factory.configure(JsonParser.Feature.STRICT_DUPLICATE_DETECTION, false);
        if (liberal) {
            factory.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
            factory.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            factory.configure(JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS, true);
            factory.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
            factory.configure(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, true);
        }
        if (this.isCalledAs("parse-json")) {
            return this.parse(args[0], handleDuplicates, factory);
        }
        return this.parseResource(args[0], handleDuplicates, factory);
    }

    private Sequence parse(Sequence json, String handleDuplicates, JsonFactory factory) throws XPathException {
        if (json.isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        try {
            JsonParser parser = factory.createParser(json.itemAt(0).getStringValue());
            Item result = JSON.readValue(this.context, parser, handleDuplicates);
            return result == null ? Sequence.EMPTY_SEQUENCE : result.toSequence();
        }
        catch (IOException e) {
            throw new XPathException((Expression)this, ErrorCodes.FOJS0001, e.getMessage());
        }
        catch (XPathException e) {
            e.setLocation(this.getLine(), this.getColumn(), this.getSource());
            throw e;
        }
    }

    private Sequence parseResource(Sequence href, String handleDuplicates, JsonFactory factory) throws XPathException {
        if (href.isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        try {
            Source source;
            String url = href.getStringValue();
            if (url.indexOf(58) == -1) {
                url = "xmldb:exist://" + url;
            }
            if ((source = SourceFactory.getSource(this.context.getBroker(), "", url, false)) == null) {
                throw new XPathException((Expression)this, ErrorCodes.FOUT1170, "failed to load json doc from URI " + url);
            }
            InputStream is = source.getInputStream();
            JsonParser parser = factory.createParser(is);
            Item result = JSON.readValue(this.context, parser, handleDuplicates);
            return result == null ? Sequence.EMPTY_SEQUENCE : result.toSequence();
        }
        catch (IOException | PermissionDeniedException e) {
            throw new XPathException((Expression)this, ErrorCodes.FOUT1170, e.getMessage());
        }
    }

    public static Item readValue(XQueryContext context, JsonParser parser, String handleDuplicates) throws IOException, XPathException {
        return JSON.readValue(context, parser, null, handleDuplicates);
    }

    private static Item readValue(XQueryContext context, JsonParser parser, Item parent, String handleDuplicates) throws IOException, XPathException {
        JsonToken token;
        AtomicValue next = null;
        while ((token = parser.nextValue()) != null) {
            if (token == JsonToken.END_OBJECT || token == JsonToken.END_ARRAY) {
                return parent;
            }
            switch (token) {
                case START_OBJECT: {
                    next = new MapType(context, null);
                    JSON.readValue(context, parser, next, handleDuplicates);
                    break;
                }
                case START_ARRAY: {
                    next = new ArrayType(context, Sequence.EMPTY_SEQUENCE);
                    JSON.readValue(context, parser, next, handleDuplicates);
                    break;
                }
                case VALUE_FALSE: {
                    next = BooleanValue.FALSE;
                    break;
                }
                case VALUE_TRUE: {
                    next = BooleanValue.TRUE;
                    break;
                }
                case VALUE_NUMBER_FLOAT: 
                case VALUE_NUMBER_INT: {
                    next = new StringValue(parser.getText()).convertTo(34);
                    break;
                }
                case VALUE_NULL: {
                    next = null;
                    break;
                }
                default: {
                    next = new StringValue(parser.getText());
                }
            }
            if (parent == null) continue;
            switch (parent.getType()) {
                case 103: {
                    ((ArrayType)parent).add(next == null ? Sequence.EMPTY_SEQUENCE : next.toSequence());
                    break;
                }
                case 102: {
                    String currentName = parser.getCurrentName();
                    if (currentName == null) {
                        throw new XPathException(ErrorCodes.FOJS0001, "Invalid JSON object");
                    }
                    MapType map = (MapType)parent;
                    StringValue name = new StringValue(currentName);
                    if (map.contains(name)) {
                        if (handleDuplicates.equals(OPTION_DUPLICATES_REJECT)) {
                            throw new XPathException(ErrorCodes.FOJS0003, "Duplicate key: " + currentName);
                        }
                        if (!handleDuplicates.equals(OPTION_DUPLICATES_USE_LAST)) break;
                        map.add(name, next == null ? Sequence.EMPTY_SEQUENCE : next.toSequence());
                        break;
                    }
                    map.add(name, next == null ? Sequence.EMPTY_SEQUENCE : next.toSequence());
                }
            }
        }
        return next;
    }
}

