/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.dom.memtree.NodeImpl;
import org.exist.dom.memtree.SAXAdapter;
import org.exist.validation.ValidationReport;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.validation.Shared;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.ValueSequence;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ParsingFunctions
extends BasicFunction {
    protected static final FunctionReturnSequenceType RESULT_TYPE_FOR_PARSE_XML = new FunctionReturnSequenceType(6, 3, "the parsed document");
    protected static final FunctionReturnSequenceType RESULT_TYPE_FOR_PARSE_XML_FRAGMENT = new FunctionReturnSequenceType(1, 7, "the parsed document fragment");
    protected static final FunctionParameterSequenceType TO_BE_PARSED_PARAMETER = new FunctionParameterSequenceType("arg", 22, 3, "The string to be parsed");
    protected static final Logger logger = LogManager.getLogger(ParsingFunctions.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("parse-xml", "http://www.w3.org/2005/xpath-functions"), "This function takes as input an XML document represented as a string, and returns the document node at the root of an XDM tree representing the parsed document.", new SequenceType[]{TO_BE_PARSED_PARAMETER}, RESULT_TYPE_FOR_PARSE_XML), new FunctionSignature(new QName("parse-xml-fragment", "http://www.w3.org/2005/xpath-functions"), "This function takes as input an XML external entity represented as a string,and returns the document node at the root of an XDM tree representing the parsed document fragment.", new SequenceType[]{TO_BE_PARSED_PARAMETER}, RESULT_TYPE_FOR_PARSE_XML_FRAGMENT)};

    public ParsingFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].getItemCount() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        String xmlContent = args[0].itemAt(0).getStringValue();
        if (xmlContent.length() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        if (this.isCalledAs("parse-xml-fragment")) {
            xmlContent = "<root>" + xmlContent + "</root>";
        }
        StringReader reader = new StringReader(xmlContent);
        InputSource src = new InputSource(reader);
        return this.parse(src, this.context, args);
    }

    private Sequence parse(InputSource src, XQueryContext theContext, Sequence[] args) throws XPathException {
        ValidationReport report = new ValidationReport();
        SAXAdapter adapter = new SAXAdapter(theContext);
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            XMLReader xr = null;
            if (xr == null) {
                SAXParser parser = factory.newSAXParser();
                xr = parser.getXMLReader();
            }
            xr.setErrorHandler(report);
            xr.setContentHandler(adapter);
            xr.setProperty("http://xml.org/sax/properties/lexical-handler", adapter);
            xr.parse(src);
        }
        catch (ParserConfigurationException e) {
            throw new XPathException(this, ErrorCodes.EXXQDY0002, "Error while constructing XML parser: " + e.getMessage(), args[0], e);
        }
        catch (SAXException e) {
            logger.debug("Error while parsing XML: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XPathException(this, ErrorCodes.FODC0006, ErrorCodes.FODC0006.getDescription() + ": " + e.getMessage(), args[0], e);
        }
        if (report.isValid()) {
            if (this.isCalledAs("parse-xml-fragment")) {
                ValueSequence resultSequence = new ValueSequence();
                NodeList children = adapter.getDocument().getDocumentElement().getChildNodes();
                int il = children.getLength();
                for (int i = 0; i < il; ++i) {
                    Node child = children.item(i);
                    resultSequence.add((NodeValue)((Object)child));
                }
                return resultSequence;
            }
            return adapter.getDocument();
        }
        MemTreeBuilder builder = theContext.getDocumentBuilder();
        NodeImpl result = Shared.writeReport(report, builder);
        throw new XPathException(this, ErrorCodes.FODC0006, ErrorCodes.FODC0006.getDescription() + ": " + report.toString(), result);
    }
}

