/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.inspect;

import java.util.Map;
import org.exist.dom.QName;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Cardinality;
import org.exist.xquery.ExternalModule;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Module;
import org.exist.xquery.UserDefinedFunction;
import org.exist.xquery.VariableDeclaration;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.inspect.InspectFunction;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;
import org.exist.xquery.xqdoc.XQDocHelper;
import org.xml.sax.helpers.AttributesImpl;

public class InspectModule
extends BasicFunction {
    public static final FunctionSignature FNS_INSPECT_MODULE = new FunctionSignature(new QName("inspect-module", "http://exist-db.org/xquery/inspection", "inspect"), "Compiles a library module from source (without importing it) and returns an XML fragment describing the module and the functions/variables contained in it.", new SequenceType[]{new FunctionParameterSequenceType("location", 25, 2, "The location URI of the module to inspect")}, new FunctionReturnSequenceType(1, 3, "An XML fragment describing the module and all functions contained in it."));
    public static final FunctionSignature FNS_INSPECT_MODULE_URI = new FunctionSignature(new QName("inspect-module-uri", "http://exist-db.org/xquery/inspection", "inspect"), "Returns an XML fragment describing the library module identified by the given namespace URI and the functions/variables contained in it.", new SequenceType[]{new FunctionParameterSequenceType("uri", 25, 2, "The namespace URI of the module to inspect")}, new FunctionReturnSequenceType(1, 3, "An XML fragment describing the module and all functions contained in it."));
    private static final QName MODULE_QNAME = new QName("module", "");
    private static final QName VARIABLE_QNAME = new QName("variable", "");

    public InspectModule(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        void var10_15;
        XQueryContext tempContext = new XQueryContext(this.context.getBroker().getBrokerPool());
        tempContext.setModuleLoadPath(this.context.getModuleLoadPath());
        Module module = this.isCalledAs("inspect-module") ? tempContext.importModule(null, null, args[0].getStringValue()) : tempContext.importModule(args[0].getStringValue(), null, null);
        if (module == null) {
            return Sequence.EMPTY_SEQUENCE;
        }
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        AttributesImpl attribs = new AttributesImpl();
        attribs.addAttribute("", "uri", "uri", "CDATA", module.getNamespaceURI());
        attribs.addAttribute("", "prefix", "prefix", "CDATA", module.getDefaultPrefix());
        if (module.isInternalModule()) {
            attribs.addAttribute("", "location", "location", "CDATA", "java:" + module.getClass().getName());
        } else if (this.isCalledAs("inspect-module")) {
            attribs.addAttribute("", "location", "location", "CDATA", args[0].getStringValue());
        }
        int nodeNr = builder.startElement(MODULE_QNAME, attribs);
        if (!module.isInternalModule()) {
            XQDocHelper.parse((ExternalModule)module);
        }
        if (module.getDescription() != null) {
            builder.startElement(InspectFunction.DESCRIPTION_QNAME, null);
            builder.characters(module.getDescription());
            builder.endElement();
        }
        if (!module.isInternalModule()) {
            ExternalModule externalModule = (ExternalModule)module;
            if (externalModule.getMetadata() != null) {
                for (Map.Entry entry : externalModule.getMetadata().entrySet()) {
                    builder.startElement(new QName((String)entry.getKey(), ""), null);
                    builder.characters((CharSequence)entry.getValue());
                    builder.endElement();
                }
            }
            for (VariableDeclaration variableDeclaration : externalModule.getVariableDeclarations()) {
                attribs.clear();
                attribs.addAttribute("", "name", "name", "CDATA", variableDeclaration.getName().toString());
                SequenceType type = variableDeclaration.getSequenceType();
                if (type != null) {
                    attribs.addAttribute("", "type", "type", "CDATA", Type.getTypeName(type.getPrimaryType()));
                    attribs.addAttribute("", "cardinality", "cardinality", "CDATA", Cardinality.getDescription(type.getCardinality()));
                }
                builder.startElement(VARIABLE_QNAME, attribs);
                builder.endElement();
            }
        }
        FunctionSignature[] functionSignatureArray = module.listFunctions();
        int n = functionSignatureArray.length;
        boolean bl = false;
        while (var10_15 < n) {
            FunctionSignature sig = functionSignatureArray[var10_15];
            if (!sig.isPrivate()) {
                UserDefinedFunction func = null;
                if (!module.isInternalModule()) {
                    func = ((ExternalModule)module).getFunction(sig.getName(), sig.getArgumentCount(), null);
                }
                InspectFunction.generateDocs(sig, func, builder);
            }
            ++var10_15;
        }
        builder.endElement();
        return builder.getDocument().getNode(nodeNr);
    }
}

