/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.inspect;

import java.util.Iterator;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionCall;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Module;
import org.exist.xquery.UserDefinedFunction;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.fn.FunOnFunctions;
import org.exist.xquery.functions.fn.LoadXQueryModule;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReference;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.ValueSequence;

public class ModuleFunctions
extends BasicFunction {
    public static final FunctionSignature FNS_MODULE_FUNCTIONS_CURRENT = new FunctionSignature(new QName("module-functions", "http://exist-db.org/xquery/inspection", "inspect"), "Returns a sequence of function items pointing to each public function in the current module.", new SequenceType[0], new FunctionReturnSequenceType(101, 7, "Sequence of function items containing all public functions in the current module or the empty sequence if the module is not known in the current context."));
    public static final FunctionSignature FNS_MODULE_FUNCTIONS_OTHER = new FunctionSignature(new QName("module-functions", "http://exist-db.org/xquery/inspection", "inspect"), "Returns a sequence of function items pointing to each public function in the specified module.", new SequenceType[]{new FunctionParameterSequenceType("location", 25, 2, "The location URI of the module to be loaded.")}, new FunctionReturnSequenceType(101, 7, "Sequence of function items containing all public functions in the module or the empty sequence if the module is not known in the current context."));
    public static final FunctionSignature FNS_MODULE_FUNCTIONS_OTHER_URI = new FunctionSignature(new QName("module-functions-by-uri", "http://exist-db.org/xquery/inspection", "inspect"), "Returns a sequence of function items pointing to each public function in the specified module.", new SequenceType[]{new FunctionParameterSequenceType("uri", 25, 2, "The URI of the module to be loaded.")}, new FunctionReturnSequenceType(101, 7, "Sequence of function items containing all public functions in the module or the empty sequence if the module is not known in the current context."));

    public ModuleFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        ValueSequence list = new ValueSequence();
        if (this.getArgumentCount() == 1) {
            XQueryContext tempContext = new XQueryContext(this.context.getBroker().getBrokerPool());
            tempContext.setModuleLoadPath(this.context.getModuleLoadPath());
            Module module = null;
            try {
                module = this.isCalledAs("module-functions-by-uri") ? tempContext.importModule(args[0].getStringValue(), null, null) : tempContext.importModule(null, null, args[0].getStringValue());
            }
            catch (XPathException e) {
                LOG.debug("Failed to import module: " + args[0].getStringValue() + ": " + e.getMessage(), (Throwable)e);
                if (e.getErrorCode().equals(ErrorCodes.XPST0003)) {
                    throw new XPathException((Expression)this, e.getMessage());
                }
            }
            catch (Exception e) {
                LOG.debug("Failed to import module: " + args[0].getStringValue() + ": " + e.getMessage(), (Throwable)e);
            }
            if (module == null) {
                return Sequence.EMPTY_SEQUENCE;
            }
            LoadXQueryModule.addFunctionRefsFromModule(this, tempContext, list, module);
        } else {
            this.addFunctionRefsFromContext(list);
        }
        return list;
    }

    private void addFunctionRefsFromContext(ValueSequence resultSeq) throws XPathException {
        Iterator<UserDefinedFunction> i = this.context.localFunctions();
        while (i.hasNext()) {
            UserDefinedFunction f = i.next();
            FunctionCall call = FunOnFunctions.lookupFunction(this, f.getSignature().getName(), f.getSignature().getArgumentCount());
            if (call == null) continue;
            resultSeq.add(new FunctionReference(call));
        }
    }
}

