/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.map;

import java.util.Map;
import org.exist.dom.QName;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.map.AbstractMapType;
import org.exist.xquery.functions.map.MapType;
import org.exist.xquery.functions.map.SingleKeyMapType;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReference;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.ValueSequence;

public class MapFunction
extends BasicFunction {
    private static final QName QN_MERGE = new QName("merge", "http://www.w3.org/2005/xpath-functions/map", "map");
    private static final QName QN_SIZE = new QName("size", "http://www.w3.org/2005/xpath-functions/map", "map");
    private static final QName QN_ENTRY = new QName("entry", "http://www.w3.org/2005/xpath-functions/map", "map");
    private static final QName QN_GET = new QName("get", "http://www.w3.org/2005/xpath-functions/map", "map");
    private static final QName QN_PUT = new QName("put", "http://www.w3.org/2005/xpath-functions/map", "map");
    private static final QName QN_CONTAINS = new QName("contains", "http://www.w3.org/2005/xpath-functions/map", "map");
    private static final QName QN_KEYS = new QName("keys", "http://www.w3.org/2005/xpath-functions/map", "map");
    private static final QName QN_REMOVE = new QName("remove", "http://www.w3.org/2005/xpath-functions/map", "map");
    private static final QName QN_FOR_EACH = new QName("for-each", "http://www.w3.org/2005/xpath-functions/map", "map");
    @Deprecated
    private static final QName QN_NEW = new QName("new", "http://www.w3.org/2005/xpath-functions/map", "map");
    @Deprecated
    private static final QName QN_FOR_EACH_ENTRY = new QName("for-each-entry", "http://www.w3.org/2005/xpath-functions/map", "map");
    public static final FunctionSignature FNS_MERGE = new FunctionSignature(QN_MERGE, "Returns a map that combines the entries from a number of existing maps.", new SequenceType[]{new FunctionParameterSequenceType("maps", 102, 7, "Existing maps to merge to create a new map.")}, new SequenceType(102, 2));
    public static final FunctionSignature FNS_SIZE = new FunctionSignature(QN_SIZE, "Returns the number of entries in the supplied map.", new SequenceType[]{new FunctionParameterSequenceType("input", 102, 2, "Any map to determine the size of.")}, new SequenceType(31, 2));
    public static final FunctionSignature FNS_KEYS = new FunctionSignature(QN_KEYS, "Returns a sequence containing all the key values present in a map.", new SequenceType[]{new FunctionParameterSequenceType("map", 102, 2, "The map")}, new SequenceType(20, 7));
    public static final FunctionSignature FNS_CONTAINS = new FunctionSignature(QN_CONTAINS, "Tests whether a supplied map contains an entry for a given key.", new SequenceType[]{new FunctionParameterSequenceType("map", 102, 2, "The map"), new FunctionParameterSequenceType("key", 20, 2, "The key to look up")}, new SequenceType(23, 2));
    public static final FunctionSignature FNS_GET = new FunctionSignature(QN_GET, "Returns the value associated with a supplied key in a given map.", new SequenceType[]{new FunctionParameterSequenceType("map", 102, 2, "The map"), new FunctionParameterSequenceType("key", 20, 2, "The key to look up")}, new SequenceType(11, 7));
    public static final FunctionSignature FNS_PUT = new FunctionSignature(QN_PUT, "Returns a map containing all the contents of the supplied map, but with an additional entry, which replaces any existing entry for the same key.", new SequenceType[]{new FunctionParameterSequenceType("map", 102, 2, "The map"), new FunctionParameterSequenceType("key", 20, 2, "The key for the entry to insert"), new FunctionParameterSequenceType("value", 11, 7, "The value for the entry to insert")}, new SequenceType(102, 2));
    public static final FunctionSignature FNS_ENTRY = new FunctionSignature(QN_ENTRY, "Creates a map that contains a single entry (a key-value pair).", new SequenceType[]{new FunctionParameterSequenceType("key", 20, 2, "The key"), new FunctionParameterSequenceType("value", 11, 7, "The associated value")}, new SequenceType(102, 2));
    public static final FunctionSignature FNS_REMOVE = new FunctionSignature(QN_REMOVE, "Constructs a new map by removing an entry from an existing map.", new SequenceType[]{new FunctionParameterSequenceType("map", 102, 2, "The map"), new FunctionParameterSequenceType("key", 22, 2, "The key to remove")}, new SequenceType(102, 2));
    public static final FunctionSignature FNS_FOR_EACH = new FunctionSignature(QN_FOR_EACH, "takes any map as its $input argument and applies the supplied function to each entry in the map, in implementation-dependent order; the result is the sequence obtained by concatenating the results of these function calls. The function supplied as $action takes two arguments. It is called supplying the key of the map entry as the first argument, and the associated value as the second argument.", new SequenceType[]{new FunctionParameterSequenceType("input", 102, 2, "The map"), new FunctionParameterSequenceType("action", 101, 2, "The function to be called for each entry")}, new SequenceType(11, 7));
    @Deprecated
    public static final FunctionSignature FNS_NEW_0 = new FunctionSignature(QN_NEW, "Constructs and returns an empty map whose collation is the default collation in the static context.", null, new SequenceType(102, 2), "Use the computer map constructor `map {}` instead.");
    @Deprecated
    public static final FunctionSignature FNS_NEW_N = new FunctionSignature(QN_NEW, "Constructs and returns an empty map whose collation is the default collation in the static context.", new SequenceType[]{new FunctionParameterSequenceType("maps", 102, 7, "Existing maps to combine into the new map.")}, new SequenceType(102, 2), FNS_MERGE);
    @Deprecated
    public static final FunctionSignature FNS_NEW_N_COLLATION = new FunctionSignature(QN_NEW, "Constructs and returns an empty map whose collation is given in the second argument.", new SequenceType[]{new FunctionParameterSequenceType("maps", 102, 7, "Existing maps to combine into the new map."), new FunctionParameterSequenceType("collation", 22, 2, "The collation to use for the new map.")}, new SequenceType(102, 2), FNS_MERGE);
    @Deprecated
    public static final FunctionSignature FNS_FOR_EACH_ENTRY = new FunctionSignature(QN_FOR_EACH_ENTRY, "takes any map as its $input argument and applies the supplied function to each entry in the map, in implementation-dependent order; the result is the sequence obtained by concatenating the results of these function calls. The function supplied as $action takes two arguments. It is called supplying the key of the map entry as the first argument, and the associated value as the second argument.", new SequenceType[]{new FunctionParameterSequenceType("input", 102, 2, "The map"), new FunctionParameterSequenceType("action", 101, 2, "The function to be called for each entry")}, new SequenceType(11, 7), FNS_FOR_EACH);
    private AnalyzeContextInfo cachedContextInfo;

    public MapFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        this.cachedContextInfo = new AnalyzeContextInfo(contextInfo);
        super.analyze(contextInfo);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (this.isCalledAs(QN_NEW.getLocalPart())) {
            return this.newMap(args);
        }
        if (this.isCalledAs(QN_MERGE.getLocalPart())) {
            return this.merge(args);
        }
        if (this.isCalledAs(QN_SIZE.getLocalPart())) {
            return this.size(args);
        }
        if (this.isCalledAs(QN_KEYS.getLocalPart())) {
            return this.keys(args);
        }
        if (this.isCalledAs(QN_CONTAINS.getLocalPart())) {
            return this.contains(args);
        }
        if (this.isCalledAs(QN_GET.getLocalPart())) {
            return this.get(args);
        }
        if (this.isCalledAs(QN_PUT.getLocalPart())) {
            return this.put(args);
        }
        if (this.isCalledAs(QN_ENTRY.getLocalPart())) {
            return this.entry(args);
        }
        if (this.isCalledAs(QN_REMOVE.getLocalPart())) {
            return this.remove(args);
        }
        if (this.isCalledAs(QN_FOR_EACH.getLocalPart()) || this.isCalledAs(QN_FOR_EACH_ENTRY.getLocalPart())) {
            return this.forEach(args);
        }
        return null;
    }

    private Sequence remove(Sequence[] args) {
        AbstractMapType map = (AbstractMapType)args[0].itemAt(0);
        return map.remove((AtomicValue)args[1].itemAt(0));
    }

    private Sequence keys(Sequence[] args) {
        AbstractMapType map = (AbstractMapType)args[0].itemAt(0);
        return map.keys();
    }

    private Sequence contains(Sequence[] args) {
        AbstractMapType map = (AbstractMapType)args[0].itemAt(0);
        return BooleanValue.valueOf(map.contains((AtomicValue)args[1].itemAt(0)));
    }

    private Sequence get(Sequence[] args) {
        AbstractMapType map = (AbstractMapType)args[0].itemAt(0);
        return map.get((AtomicValue)args[1].itemAt(0));
    }

    private Sequence put(Sequence[] args) throws XPathException {
        AbstractMapType map = (AbstractMapType)args[0].itemAt(0);
        return map.put((AtomicValue)args[1].itemAt(0), args[2]);
    }

    private Sequence entry(Sequence[] args) throws XPathException {
        AtomicValue key = (AtomicValue)args[0].itemAt(0);
        return new SingleKeyMapType(this.context, null, key, args[1]);
    }

    private Sequence size(Sequence[] args) throws XPathException {
        AbstractMapType map = (AbstractMapType)args[0].itemAt(0);
        return new IntegerValue(map.size(), 31);
    }

    private Sequence merge(Sequence[] args) throws XPathException {
        if (args.length == 0) {
            return new MapType(this.context);
        }
        MapType map = new MapType(this.context, null);
        SequenceIterator i = args[0].unorderedIterator();
        while (i.hasNext()) {
            AbstractMapType m = (AbstractMapType)i.nextItem();
            map.add(m);
        }
        return map;
    }

    @Deprecated
    private Sequence newMap(Sequence[] args) throws XPathException {
        if (args.length == 0) {
            return new MapType(this.context);
        }
        String collation = null;
        if (args.length == 2) {
            collation = args[1].getStringValue();
        }
        MapType map = new MapType(this.context, collation);
        SequenceIterator i = args[0].unorderedIterator();
        while (i.hasNext()) {
            AbstractMapType m = (AbstractMapType)i.nextItem();
            map.add(m);
        }
        return map;
    }

    private Sequence forEach(Sequence[] args) throws XPathException {
        AbstractMapType map = (AbstractMapType)args[0].itemAt(0);
        FunctionReference ref = (FunctionReference)args[1].itemAt(0);
        ref.analyze(this.cachedContextInfo);
        ValueSequence result = new ValueSequence();
        for (Map.Entry entry : map) {
            Sequence s = ref.evalFunction(null, null, new Sequence[]{(Sequence)entry.getKey(), (Sequence)entry.getValue()});
            result.addAll(s);
        }
        return result;
    }
}

