/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.map;

import com.github.krukow.clj_lang.IMapEntry;
import com.github.krukow.clj_lang.IPersistentMap;
import com.github.krukow.clj_lang.PersistentHashMap;
import com.github.krukow.clj_lang.PersistentTreeMap;
import java.util.Iterator;
import java.util.Map;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.map.AbstractMapType;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.ValueSequence;

public class MapType
extends AbstractMapType {
    private IPersistentMap<AtomicValue, Sequence> map;
    private int type = 12;

    public MapType(XQueryContext context) throws XPathException {
        this(context, null);
    }

    public MapType(XQueryContext context, String collation) throws XPathException {
        super(context);
        this.map = collation == null ? PersistentHashMap.EMPTY : PersistentTreeMap.create(this.getComparator(collation), null);
    }

    public MapType(XQueryContext context, String collation, AtomicValue key, Sequence value) throws XPathException {
        super(context);
        this.map = collation == null ? PersistentHashMap.EMPTY : PersistentTreeMap.create(this.getComparator(collation), null);
        this.type = key.getType();
        this.map = this.map.assoc((Object)key, (Object)value);
    }

    protected MapType(XQueryContext context, IPersistentMap<AtomicValue, Sequence> other, int type) {
        super(context);
        this.map = other;
        this.type = type;
    }

    public void add(AbstractMapType other) {
        if (other.size() == 1) {
            this.setKeyType(((AtomicValue)other.getKey()).getType());
            this.map = this.map.assoc(other.getKey(), other.getValue());
        } else if (other.size() > 0) {
            this.setKeyType(other.getKeyType());
            if (this.map instanceof PersistentHashMap) {
                PersistentHashMap.TransientHashMap tmap = ((PersistentHashMap)this.map).asTransient();
                for (Map.Entry entry : other) {
                    tmap = tmap.assoc(entry.getKey(), entry.getValue());
                }
                this.map = tmap.persistentMap();
            } else {
                for (Map.Entry entry : other) {
                    this.map = this.map.assoc(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    public void add(AtomicValue key, Sequence value) {
        this.setKeyType(key.getType());
        this.map = this.map.assoc((Object)key, (Object)value);
    }

    @Override
    public Sequence get(AtomicValue key) {
        if ((key = this.convert(key)) == null) {
            return Sequence.EMPTY_SEQUENCE;
        }
        IMapEntry e = this.map.entryAt((Object)key);
        return e == null ? Sequence.EMPTY_SEQUENCE : (Sequence)e.getValue();
    }

    @Override
    public AbstractMapType put(AtomicValue key, Sequence value) throws XPathException {
        return new MapType(this.context, (IPersistentMap<AtomicValue, Sequence>)this.map.assoc((Object)key, (Object)value), this.type);
    }

    @Override
    public boolean contains(AtomicValue key) {
        if ((key = this.convert(key)) == null) {
            return false;
        }
        return this.map.containsKey((Object)key);
    }

    @Override
    public Sequence keys() {
        ValueSequence seq = new ValueSequence();
        for (Map.Entry entry : this.map) {
            seq.add((Item)entry.getKey());
        }
        return seq;
    }

    @Override
    public AbstractMapType remove(AtomicValue key) {
        try {
            return new MapType(this.context, (IPersistentMap<AtomicValue, Sequence>)this.map.without((Object)key), this.type);
        }
        catch (Exception e) {
            return this;
        }
    }

    @Override
    public int size() {
        return this.map.count();
    }

    @Override
    public Iterator<Map.Entry<AtomicValue, Sequence>> iterator() {
        return this.map.iterator();
    }

    @Override
    public AtomicValue getKey() {
        if (this.map.count() == 0) {
            return null;
        }
        Iterator iter = this.map.iterator();
        return (AtomicValue)((Map.Entry)iter.next()).getKey();
    }

    @Override
    public Sequence getValue() {
        return this.mapToSequence(this.map);
    }

    private Sequence mapToSequence(IPersistentMap<AtomicValue, Sequence> map) {
        if (map.count() == 0) {
            return null;
        }
        Iterator iter = map.iterator();
        return (Sequence)((Map.Entry)iter.next()).getValue();
    }

    private void setKeyType(int newType) {
        if (this.type == 12) {
            this.type = newType;
        } else if (this.type != newType) {
            this.type = 11;
            if (this.map instanceof PersistentHashMap) {
                try {
                    PersistentTreeMap tmap = PersistentTreeMap.create(this.getComparator(null), null);
                    for (Map.Entry entry : this.map) {
                        tmap = tmap.assoc(entry.getKey(), entry.getValue());
                    }
                    this.map = tmap;
                }
                catch (XPathException xPathException) {
                    // empty catch block
                }
            }
        }
    }

    private AtomicValue convert(AtomicValue key) {
        if (this.type != 12 && this.type != 11) {
            try {
                return key.convertTo(this.type);
            }
            catch (XPathException e) {
                return null;
            }
        }
        return key;
    }

    @Override
    public int getKeyType() {
        return this.type;
    }
}

