/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.math;

import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.DoubleValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class OneParamFunctions
extends BasicFunction {
    public static final String ACOS = "acos";
    public static final String ASIN = "asin";
    public static final String ATAN = "atan";
    public static final String COS = "cos";
    public static final String EXP = "exp";
    public static final String EXP10 = "exp10";
    public static final String LOG = "log";
    public static final String LOG10 = "log10";
    public static final String SIN = "sin";
    public static final String SQRT = "sqrt";
    public static final String TAN = "tan";
    public static final FunctionSignature FNS_ACOS = new FunctionSignature(new QName("acos", "http://www.w3.org/2005/xpath-functions/math", "math"), "Returns the arc cosine of the argument, the result being in the range zero to +\u03c0 radians.", new SequenceType[]{new FunctionParameterSequenceType("arg", 34, 2, "The input number")}, new FunctionReturnSequenceType(34, 2, "the result"));
    public static final FunctionSignature FNS_ASIN = new FunctionSignature(new QName("asin", "http://www.w3.org/2005/xpath-functions/math", "math"), "Returns the arc sine of the argument, the result being in the range -\u03c0/2 to +\u03c0/2 radians.", new SequenceType[]{new FunctionParameterSequenceType("arg", 34, 2, "The input number")}, new FunctionReturnSequenceType(34, 2, "result"));
    public static final FunctionSignature FNS_ATAN = new FunctionSignature(new QName("atan", "http://www.w3.org/2005/xpath-functions/math", "math"), "Returns the arc tangent of the argument, the result being in the range -\u03c0/2 to +\u03c0/2 radians.", new SequenceType[]{new FunctionParameterSequenceType("arg", 34, 2, "The input number")}, new FunctionReturnSequenceType(34, 2, "the result"));
    public static final FunctionSignature FNS_COS = new FunctionSignature(new QName("cos", "http://www.w3.org/2005/xpath-functions/math", "math"), "Returns the cosine of the argument, expressed in radians.", new SequenceType[]{new FunctionParameterSequenceType("arg", 34, 2, "The input number")}, new FunctionReturnSequenceType(34, 2, "the cosine"));
    public static final FunctionSignature FNS_EXP = new FunctionSignature(new QName("exp", "http://www.w3.org/2005/xpath-functions/math", "math"), "Calculates e (the Euler Constant) raised to the power of $arg", new SequenceType[]{new FunctionParameterSequenceType("arg", 34, 2, "The input number")}, new FunctionReturnSequenceType(34, 2, "e (the Euler Constant) raised to the power of a value or expression"));
    public static final FunctionSignature FNS_EXP10 = new FunctionSignature(new QName("exp10", "http://www.w3.org/2005/xpath-functions/math", "math"), "Calculates 10 raised to the power of $arg", new SequenceType[]{new FunctionParameterSequenceType("arg", 34, 2, "The input number")}, new FunctionReturnSequenceType(34, 2, "e (the Euler Constant) raised to the power of a value or expression"));
    public static final FunctionSignature FNS_LOG = new FunctionSignature(new QName("log", "http://www.w3.org/2005/xpath-functions/math", "math"), "Returns the natural logarithm of the argument.", new SequenceType[]{new FunctionParameterSequenceType("arg", 34, 2, "The input number")}, new FunctionReturnSequenceType(34, 2, "the log"));
    public static final FunctionSignature FNS_LOG10 = new FunctionSignature(new QName("log10", "http://www.w3.org/2005/xpath-functions/math", "math"), "Returns the base-ten logarithm of the argument.", new SequenceType[]{new FunctionParameterSequenceType("arg", 34, 2, "The input number")}, new FunctionReturnSequenceType(34, 2, "the log"));
    public static final FunctionSignature FNS_SIN = new FunctionSignature(new QName("sin", "http://www.w3.org/2005/xpath-functions/math", "math"), "Returns the sine of the argument, expressed in radians.", new SequenceType[]{new FunctionParameterSequenceType("arg", 34, 2, "The input number")}, new FunctionReturnSequenceType(34, 2, "the sine"));
    public static final FunctionSignature FNS_SQRT = new FunctionSignature(new QName("sqrt", "http://www.w3.org/2005/xpath-functions/math", "math"), "Returns the non-negative square root of the argument.", new SequenceType[]{new FunctionParameterSequenceType("arg", 34, 2, "The input number")}, new FunctionReturnSequenceType(34, 2, "the square root of $x"));
    public static final FunctionSignature FNS_TAN = new FunctionSignature(new QName("tan", "http://www.w3.org/2005/xpath-functions/math", "math"), "Returns the tangent of the argument, expressed in radians.", new SequenceType[]{new FunctionParameterSequenceType("arg", 34, 2, "The radians")}, new FunctionReturnSequenceType(34, 2, "the tangent"));

    public OneParamFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        AtomicValue seq = args[0].convertTo(34);
        NumericValue value = (NumericValue)seq.itemAt(0).convertTo(34);
        if (seq.isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            double calcValue = 0.0;
            String functionName = this.getSignature().getName().getLocalPart();
            if (ACOS.equals(functionName)) {
                calcValue = Math.acos(value.getDouble());
            } else if (ASIN.equals(functionName)) {
                calcValue = Math.asin(value.getDouble());
            } else if (ATAN.equals(functionName)) {
                calcValue = Math.atan(value.getDouble());
            } else if (COS.equals(functionName)) {
                calcValue = Math.cos(value.getDouble());
            } else if (EXP.equals(functionName)) {
                calcValue = Math.exp(value.getDouble());
            } else if (EXP10.equals(functionName)) {
                calcValue = Math.pow(10.0, value.getDouble());
            } else if (LOG.equals(functionName)) {
                calcValue = Math.log(value.getDouble());
            } else if (LOG10.equals(functionName)) {
                calcValue = Math.log10(value.getDouble());
            } else if (SIN.equals(functionName)) {
                calcValue = Math.sin(value.getDouble());
            } else if (SQRT.equals(functionName)) {
                calcValue = Math.sqrt(value.getDouble());
            } else if (TAN.equals(functionName)) {
                calcValue = Math.tan(value.getDouble());
            } else {
                throw new XPathException((Expression)this, "Function " + functionName + " not found.");
            }
            result = new DoubleValue(calcValue);
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

