/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.math;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.DoubleValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class TwoParamFunctions
extends BasicFunction {
    private static final Logger logger = LogManager.getLogger(TwoParamFunctions.class);
    public static final String ATAN2 = "atan2";
    public static final String POW = "pow";
    public static final FunctionSignature FNS_ATAN2 = new FunctionSignature(new QName("atan2", "http://www.w3.org/2005/xpath-functions/math", "math"), "Returns the angle in radians subtended at the origin by the point on a plane with coordinates (x, y) and the positive x-axis, the result being in the range -\u03c0 to +\u03c0.", new SequenceType[]{new FunctionParameterSequenceType("y", 34, 2, "The y coordinate"), new FunctionParameterSequenceType("x", 34, 2, "The x coordinate")}, new FunctionReturnSequenceType(34, 2, "the theta component of the point (r, theta) in polar coordinates that corresponds to the point (x, y) in Cartesian coordinates."));
    public static final FunctionSignature FNS_POW = new FunctionSignature(new QName("pow", "http://www.w3.org/2005/xpath-functions/math", "math"), "Returns the result of raising the first argument to the power of the second.", new SequenceType[]{new FunctionParameterSequenceType("value", 34, 2, "The value"), new FunctionParameterSequenceType("power", 30, 2, "The power to raise the value to")}, new FunctionReturnSequenceType(34, 2, "the result"));

    public TwoParamFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        double calcValue = 0.0;
        String functionName = this.getSignature().getName().getLocalPart();
        AtomicValue seqA = args[0].convertTo(34);
        NumericValue valueA = (NumericValue)seqA.itemAt(0).convertTo(34);
        AtomicValue seqB = args[1].convertTo(34);
        NumericValue valueB = (NumericValue)seqB.itemAt(0).convertTo(34);
        if (ATAN2.equals(functionName)) {
            calcValue = Math.atan2(valueA.getDouble(), valueB.getDouble());
        } else if (POW.equals(functionName)) {
            calcValue = Math.pow(valueA.getDouble(), valueB.getDouble());
        } else {
            throw new XPathException((Expression)this, "Function " + functionName + " not found.");
        }
        DoubleValue result = new DoubleValue(calcValue);
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

