/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.securitymanager;

import org.exist.config.ConfigurationException;
import org.exist.dom.QName;
import org.exist.security.Account;
import org.exist.security.PermissionDeniedException;
import org.exist.security.SecurityManager;
import org.exist.security.Subject;
import org.exist.storage.DBBroker;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class AccountStatusFunction
extends BasicFunction {
    private static final QName qnIsAccountEnabled = new QName("is-account-enabled", "http://exist-db.org/xquery/securitymanager", "sm");
    private static final QName qnSetAccountEnabled = new QName("set-account-enabled", "http://exist-db.org/xquery/securitymanager", "sm");
    public static final FunctionSignature FNS_IS_ACCOUNT_ENABLED = new FunctionSignature(qnIsAccountEnabled, "Determines whether a user account is enabled. You must be a DBA, or you must be enquiring about your own user account.", new SequenceType[]{new FunctionParameterSequenceType("username", 22, 2, "The username of the account to check the status for.")}, new FunctionReturnSequenceType(23, 2, "true if the account is enabled, false otherwise."));
    public static final FunctionSignature FNS_SET_ACCOUNT_ENABLED = new FunctionSignature(qnSetAccountEnabled, "Enabled or disables a users account. You must be a DBA to enable or disable an account.", new SequenceType[]{new FunctionParameterSequenceType("username", 22, 2, "The username of the account to enable or disable."), new FunctionParameterSequenceType("enabled", 23, 2, "true to enable the account, false to disable the account.")}, new SequenceType(10, 1));

    public AccountStatusFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        DBBroker broker = this.getContext().getBroker();
        Subject currentUser = broker.getCurrentSubject();
        SecurityManager securityManager = broker.getBrokerPool().getSecurityManager();
        String username = args[0].getStringValue();
        if (this.isCalledAs(qnIsAccountEnabled.getLocalPart())) {
            if (!currentUser.hasDbaRole() && !currentUser.getName().equals(username)) {
                throw new XPathException("You must be a DBA or be enquiring about your own account!");
            }
            Account account = securityManager.getAccount(username);
            return new BooleanValue(account.isEnabled());
        }
        if (this.isCalledAs(qnSetAccountEnabled.getLocalPart())) {
            if (!currentUser.hasDbaRole()) {
                throw new XPathException("You must be a DBA to change the status of an account!");
            }
            boolean enable = args[1].effectiveBooleanValue();
            Account account = securityManager.getAccount(username);
            account.setEnabled(enable);
            try {
                account.save(broker);
                return Sequence.EMPTY_SEQUENCE;
            }
            catch (ConfigurationException ce) {
                throw new XPathException(ce.getMessage(), (Throwable)ce);
            }
            catch (PermissionDeniedException pde) {
                throw new XPathException(pde.getMessage(), (Throwable)pde);
            }
        }
        throw new XPathException("Unknown function");
    }
}

