/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.securitymanager;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.exist.dom.QName;
import org.exist.security.Account;
import org.exist.security.SecurityManager;
import org.exist.security.Subject;
import org.exist.storage.DBBroker;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;

public class FindGroupFunction
extends BasicFunction {
    private static final QName qnFindGroupsByGroupname = new QName("find-groups-by-groupname", "http://exist-db.org/xquery/securitymanager", "sm");
    private static final QName qnListGroups = new QName("list-groups", "http://exist-db.org/xquery/securitymanager", "sm");
    private static final QName qnFindGroupsWhereGroupnameContains = new QName("find-groups-where-groupname-contains", "http://exist-db.org/xquery/securitymanager", "sm");
    private static final QName qnGetUserGroups = new QName("get-user-groups", "http://exist-db.org/xquery/securitymanager", "sm");
    private static final QName qnGetUserPrimaryGroup = new QName("get-user-primary-group", "http://exist-db.org/xquery/securitymanager", "sm");
    private static final QName qnGroupExists = new QName("group-exists", "http://exist-db.org/xquery/securitymanager", "sm");
    private static final QName qnGetGroups = new QName("get-groups", "http://exist-db.org/xquery/securitymanager", "sm");
    public static final FunctionSignature FNS_LIST_GROUPS = new FunctionSignature(qnListGroups, "List all groups", null, new FunctionReturnSequenceType(22, 7, "The list of groups"));
    public static final FunctionSignature FNS_GET_GROUPS = new FunctionSignature(qnGetGroups, "List all groups", null, (SequenceType)new FunctionReturnSequenceType(22, 7, "The list of groups"), FNS_LIST_GROUPS);
    public static final FunctionSignature FNS_FIND_GROUPS_BY_GROUPNAME = new FunctionSignature(qnFindGroupsByGroupname, "Finds groups whoose group name starts with a matching string", new SequenceType[]{new FunctionParameterSequenceType("starts-with", 22, 2, "The starting string against which to match group names")}, new FunctionReturnSequenceType(22, 7, "The list of matching group names"));
    public static final FunctionSignature FNS_FIND_GROUPS_WHERE_GROUPNAME_CONTANINS = new FunctionSignature(qnFindGroupsWhereGroupnameContains, "Finds groups whoose group name contains the string fragment", new SequenceType[]{new FunctionParameterSequenceType("fragment", 22, 2, "The fragment against which to match group names")}, new FunctionReturnSequenceType(22, 7, "The list of matching group names"));
    public static final FunctionSignature FNS_GET_USER_GROUPS = new FunctionSignature(qnGetUserGroups, "Returns the sequence of groups that the user $user is a member of. You must be a DBA or logged in as the user for which you are trying to retrieve group details for.", new SequenceType[]{new FunctionParameterSequenceType("user", 22, 2, "The username to retrieve the group membership list for.")}, new FunctionReturnSequenceType(22, 6, "The users group memberships"));
    public static final FunctionSignature FNS_GET_USER_PRIMARY_GROUP = new FunctionSignature(qnGetUserPrimaryGroup, "Returns the primary group of the user $user. You must be a DBA or logged in as the user for which you are trying to retrieve group details for.", new SequenceType[]{new FunctionParameterSequenceType("user", 22, 2, "The username to retrieve the primary group of.")}, new FunctionReturnSequenceType(22, 2, "The users primary group"));
    public static final FunctionSignature FNS_GROUP_EXISTS = new FunctionSignature(qnGroupExists, "Determines whether a user group exists.", new SequenceType[]{new FunctionParameterSequenceType("group", 22, 2, "The name of the user group to check for existence.")}, new FunctionReturnSequenceType(23, 2, "true if the user group exists, false otherwise."));

    public FindGroupFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence result;
        DBBroker broker = this.getContext().getBroker();
        Subject currentUser = broker.getCurrentSubject();
        if (!this.isCalledAs(qnGetUserGroups.getLocalPart()) && currentUser.getName().equals("guest")) {
            throw new XPathException("You must be an authenticated user");
        }
        SecurityManager securityManager = broker.getBrokerPool().getSecurityManager();
        if (this.isCalledAs(qnGetUserPrimaryGroup.getLocalPart())) {
            String username = args[0].getStringValue();
            result = new StringValue(securityManager.getAccount(username).getPrimaryGroup());
        } else if (this.isCalledAs(qnGroupExists.getLocalPart())) {
            String groupName = args[0].getStringValue();
            result = BooleanValue.valueOf(securityManager.hasGroup(groupName));
        } else {
            List<String> groupNames;
            if (this.isCalledAs(qnListGroups.getLocalPart()) || this.isCalledAs(qnGetGroups.getLocalPart())) {
                groupNames = securityManager.findAllGroupNames();
            } else if (this.isCalledAs(qnFindGroupsByGroupname.getLocalPart())) {
                String startsWith = args[0].getStringValue();
                groupNames = securityManager.findGroupnamesWhereGroupnameStarts(startsWith);
            } else if (this.isCalledAs(qnFindGroupsWhereGroupnameContains.getLocalPart())) {
                String fragment = args[0].getStringValue();
                groupNames = securityManager.findGroupnamesWhereGroupnameContains(fragment);
            } else if (this.isCalledAs(qnGetUserGroups.getLocalPart())) {
                String username = args[0].getStringValue();
                if (!currentUser.hasDbaRole() && !currentUser.getName().equals(username)) {
                    throw new XPathException("You must be a DBA or enquiring about your own user account!");
                }
                Account user = securityManager.getAccount(username);
                groupNames = Arrays.asList(user.getGroups());
            } else {
                throw new XPathException("Unknown function");
            }
            Collections.sort(groupNames);
            result = new ValueSequence();
            for (String groupName : groupNames) {
                result.add(new StringValue(groupName));
            }
        }
        return result;
    }
}

