/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.securitymanager;

import java.util.Collections;
import java.util.List;
import org.exist.dom.QName;
import org.exist.security.SecurityManager;
import org.exist.security.Subject;
import org.exist.storage.DBBroker;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;

public class FindUserFunction
extends BasicFunction {
    private static final QName qnFindUsersByUsername = new QName("find-users-by-username", "http://exist-db.org/xquery/securitymanager", "sm");
    private static final QName qnFindUsersByName = new QName("find-users-by-name", "http://exist-db.org/xquery/securitymanager", "sm");
    private static final QName qnFindUsersByNamePart = new QName("find-users-by-name-part", "http://exist-db.org/xquery/securitymanager", "sm");
    private static final QName qnListUsers = new QName("list-users", "http://exist-db.org/xquery/securitymanager", "sm");
    private static final QName qnUserExists = new QName("user-exists", "http://exist-db.org/xquery/securitymanager", "sm");
    public static final FunctionSignature FNS_FIND_USERS_BY_USERNAME = new FunctionSignature(qnFindUsersByUsername, "Finds users whoose username starts with a matching string", new SequenceType[]{new FunctionParameterSequenceType("starts-with", 22, 2, "The starting string against which to match usernames")}, new FunctionReturnSequenceType(22, 7, "The list of matching usernames"));
    public static final FunctionSignature FNS_FIND_USERS_BY_NAME = new FunctionSignature(qnFindUsersByName, "Finds users whoose personal name starts with a matching string", new SequenceType[]{new FunctionParameterSequenceType("starts-with", 22, 2, "The starting string against which to match a personal name")}, new FunctionReturnSequenceType(22, 7, "The list of matching usernames"));
    public static final FunctionSignature FNS_FIND_USERS_BY_NAME_PART = new FunctionSignature(qnFindUsersByNamePart, "Finds users whoose first name or last name starts with a matching string", new SequenceType[]{new FunctionParameterSequenceType("starts-with", 22, 2, "The starting string against which to match a first or last name")}, new FunctionReturnSequenceType(22, 7, "The list of matching usernames"));
    public static final FunctionSignature FNS_LIST_USERS = new FunctionSignature(qnListUsers, "List all users. You must be a DBA to enumerate all users, if you are not a DBA you will just get the username of the currently logged in user.", null, new FunctionReturnSequenceType(22, 6, "The list of users."));
    public static final FunctionSignature FNS_USER_EXISTS = new FunctionSignature(qnUserExists, "Determines whether a user exists.", new SequenceType[]{new FunctionParameterSequenceType("user", 22, 2, "The username to check for existence.")}, new FunctionReturnSequenceType(23, 2, "true if the user account exists, false otherwise."));

    public FindUserFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence result;
        DBBroker broker = this.getContext().getBroker();
        Subject currentUser = broker.getCurrentSubject();
        SecurityManager securityManager = broker.getBrokerPool().getSecurityManager();
        if (this.isCalledAs(qnListUsers.getLocalPart())) {
            result = new ValueSequence();
            if (currentUser.getName().equals("guest")) {
                result.add(new StringValue("guest"));
            } else {
                this.addUserNamesToSequence(securityManager.findAllUserNames(), result);
            }
        } else {
            if (currentUser.getName().equals("guest")) {
                throw new XPathException("You must be an authenticated user");
            }
            if (this.isCalledAs(qnUserExists.getLocalPart())) {
                String username = args[0].getStringValue();
                result = BooleanValue.valueOf(securityManager.hasAccount(username));
            } else {
                List<String> usernames;
                result = new ValueSequence();
                String startsWith = args[0].getStringValue();
                if (this.isCalledAs(qnFindUsersByUsername.getLocalPart())) {
                    usernames = securityManager.findUsernamesWhereUsernameStarts(startsWith);
                } else if (this.isCalledAs(qnFindUsersByName.getLocalPart())) {
                    usernames = securityManager.findUsernamesWhereNameStarts(startsWith);
                } else if (this.isCalledAs(qnFindUsersByNamePart.getLocalPart())) {
                    usernames = securityManager.findUsernamesWhereNamePartStarts(startsWith);
                } else {
                    throw new XPathException("Unknown function");
                }
                this.addUserNamesToSequence(usernames, result);
            }
        }
        return result;
    }

    private void addUserNamesToSequence(List<String> userNames, Sequence sequence) throws XPathException {
        Collections.sort(userNames);
        for (String userName : userNames) {
            sequence.add(new StringValue(userName));
        }
    }
}

